package de.mklinger.qetch.client.model.v1.impl;

import java.util.Objects;

import de.mklinger.qetch.client.model.v1.Availability;
import de.mklinger.qetch.client.model.v1.ModelValidationException;
import de.mklinger.qetch.client.model.v1.builder.AvailabilityBuilder;

/**
 * @author Marc Klinger - mklinger[at]mklinger[dot]de
 */
public class AvailabilityImpl implements Availability {
	private final String nodeId;
	private final String converterId;

	public AvailabilityImpl(final AvailabilityBuilder builder) {
		this.nodeId = builder.getNodeId();
		this.converterId = builder.getConverterId();

		try {
			validate();
		} catch (final Exception e) {
			throw new ModelValidationException(Availability.class, e);
		}
	}

	private void validate() {
		Objects.requireNonNull(nodeId);
		Objects.requireNonNull(converterId);
	}

	@Override
	public String getNodeId() {
		return nodeId;
	}

	@Override
	public String getConverterId() {
		return converterId;
	}

}
