package de.mklinger.qetch.client.model.v1.builder;

import de.mklinger.qetch.client.model.v1.Error;
import de.mklinger.qetch.client.model.v1.impl.ErrorImpl;

/**
 * Created by Marius Heinzmann on 3/26/18.
 *
 * @author Marius Heinzmann - mheinzmann[at]mklinger[dot]de
 */
public class ErrorBuilder {
	private String status;
	private String message;
	private String errorId;

	public static ErrorBuilder of(final Error error) {
		return new ErrorBuilder()
				.status(error.getStatus())
				.message(error.getMessage())
				.errorId(error.getErrorId());
	}

	public ErrorBuilder status(final String status) {
		this.status = status;
		return this;
	}

	public ErrorBuilder message(final String message) {
		this.message = message;
		return this;
	}

	public ErrorBuilder errorId(final String errorId) {
		this.errorId = errorId;
		return this;
	}

	public Error build() {
		return new ErrorImpl(this);
	}

	public String getStatus() {
		return status;
	}

	public String getMessage() {
		return message;
	}

	public String getErrorId() {
		return errorId;
	}
}
