package de.mklinger.qetch.client.model.v1.builder;

import java.util.List;

import de.mklinger.qetch.client.model.v1.AvailableConversion;
import de.mklinger.qetch.client.model.v1.AvailableConversions;
import de.mklinger.qetch.client.model.v1.impl.AvailableConversionsImpl;

/**
 * @author Marc Klinger - mklinger[at]mklinger[dot]de
 */
public class AvailableConversionsBuilder {
	private List<AvailableConversion> availableConversions;

	public static AvailableConversionsBuilder of(final AvailableConversions availableConversions) {
		return new AvailableConversionsBuilder()
				.availableConversions(availableConversions.getAvailableConversions());
	}

	public AvailableConversionsBuilder availableConversions(final List<AvailableConversion> availableConversions) {
		this.availableConversions = availableConversions;
		return this;
	}

	public List<AvailableConversion> getAvailableConversions() {
		return availableConversions;
	}

	public AvailableConversions build() {
		return new AvailableConversionsImpl(this);
	}
}
