package de.mklinger.qetch.client.impl.lookup;

import java.net.URI;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;

/**
 * @author Marc Klinger - mklinger[at]mklinger[dot]de
 */
public class StaticServiceUriSupplier implements ServiceUriSupplier {
	private final List<URI> serviceUris;

	public StaticServiceUriSupplier(final List<URI> serviceUris) {
		this.serviceUris = requireNonEmpty(serviceUris);
	}

	private static <T> List<T> requireNonEmpty(final List<T> l) {
		if (l == null  || l.isEmpty()) {
			throw new IllegalArgumentException();
		}
		return l;
	}

	@Override
	public URI get() {
		final int randomIdx = ThreadLocalRandom.current()
				.nextInt(serviceUris.size());

		return serviceUris.get(randomIdx);
	}
}
