package de.mklinger.qetch.client.impl.lookup;

import de.mklinger.qetch.client.impl.QetchClientBuilderImpl;
import de.mklinger.qetch.client.impl.retry.RetryingQetchClientImpl;
import de.mklinger.qetch.client.common.Closeables;

/**
 * @author Marc Klinger - mklinger[at]mklinger[dot]de
 */
public class NodeLookupQetchClientImpl extends RetryingQetchClientImpl {
	private final ScheduledNodesLookup nodesLookup;

	public NodeLookupQetchClientImpl(final QetchClientBuilderImpl builder) {
		super(builder, newDynamicServiceUriSupplier(builder));
		this.nodesLookup = new ScheduledNodesLookup(
				this,
				getServiceUriSupplier().getNodesHolder());
		this.nodesLookup.startDelayed();
	}

	private static ServiceUriSupplier newDynamicServiceUriSupplier(final QetchClientBuilderImpl builder) {
		return new DynamicServiceUriSupplier(builder.getServiceUris());
	}

	@Override
	public DynamicServiceUriSupplier getServiceUriSupplier() {
		return (DynamicServiceUriSupplier) super.getServiceUriSupplier();
	}

	@Override
	public void close() {
		Closeables.closeUnchecked(nodesLookup, super::close);
	}
}
