package de.mklinger.qetch.client.impl;

import java.time.Duration;

import de.mklinger.qetch.client.InputConversionFile;
import de.mklinger.qetch.client.InputJob;
import de.mklinger.qetch.client.common.MediaType;
import de.mklinger.qetch.client.model.v1.ConversionFile;

/**
 * @author Marc Klinger - mklinger[at]mklinger[dot]de
 */
public class InputJobBuilderImpl implements InputJob.Builder {
	private String conversionFileId;
	private InputConversionFile inputConversionFile;
	private MediaType fromMediaType;
	private MediaType toMediaType;
	private Duration deleteTimeout;
	private Duration cancelTimeout;
	private String referrer;

	@Override
	public InputJob.Builder fromFile(final String conversionFileId) {
		this.conversionFileId = conversionFileId;
		return this;
	}

	@Override
	public InputJob.Builder fromFile(final ConversionFile conversionFile) {
		this.conversionFileId = conversionFile.getFileId();
		return this;
	}

	public String getConversionFileId() {
		return conversionFileId;
	}

	@Override
	public InputJob.Builder fromFile(final InputConversionFile inputConversionFile) {
		this.inputConversionFile = inputConversionFile;
		return this;
	}

	public InputConversionFile getInputConversionFile() {
		return inputConversionFile;
	}

	@Override
	public InputJob.Builder fromMediaType(final MediaType mediaType) {
		this.fromMediaType = mediaType;
		return this;
	}

	public MediaType getFromMediaType() {
		return fromMediaType;
	}

	@Override
	public InputJob.Builder toMediaType(final MediaType mediaType) {
		this.toMediaType = mediaType;
		return this;
	}

	public MediaType getToMediaType() {
		return toMediaType;
	}

	@Override
	public InputJob.Builder deleteTimeout(final Duration deleteTimeout) {
		this.deleteTimeout = deleteTimeout;
		return this;
	}

	public Duration getDeleteTimeout() {
		return deleteTimeout;
	}

	@Override
	public InputJob.Builder cancelTimeout(final Duration cancelTimeout) {
		this.cancelTimeout = cancelTimeout;
		return this;
	}

	public Duration getCancelTimeout() {
		return cancelTimeout;
	}

	@Override
	public InputJob.Builder referrer(final String referrer) {
		this.referrer = referrer;
		return this;
	}

	public String getReferrer() {
		return referrer;
	}

	@Override
	public InputJob build() {
		return InstanceFactory.newInstance(this);
	}
}