package de.mklinger.qetch.client.impl;

import java.time.Duration;

import de.mklinger.commons.httpclient.HttpRequest.BodyProvider;
import de.mklinger.qetch.client.InputConversionFile;
import de.mklinger.qetch.client.common.MediaType;

/**
 * @author Marc Klinger - mklinger[at]mklinger[dot]de
 */
public class InputConversionFileBuilderImpl implements InputConversionFile.Builder {
	private BodyProvider bodyProvider;
	private MediaType mediaType;
	private String filename;
	private Duration deleteTimeout;

	@Override
	public InputConversionFile.Builder bodyProvider(final BodyProvider bodyProvider) {
		this.bodyProvider = bodyProvider;
		return this;
	}

	public BodyProvider getBodyProvider() {
		return bodyProvider;
	}

	@Override
	public InputConversionFile.Builder mediaType(final MediaType mediaType) {
		this.mediaType = mediaType;
		return this;
	}

	public MediaType getMediaType() {
		return mediaType;
	}

	@Override
	public InputConversionFile.Builder filename(final String filename) {
		this.filename = filename;
		return this;
	}

	public String getFilename() {
		return filename;
	}

	@Override
	public InputConversionFile.Builder deleteTimeout(final Duration deleteTimeout) {
		this.deleteTimeout = deleteTimeout;
		return this;
	}

	public Duration getDeleteTimeout() {
		return deleteTimeout;
	}

	@Override
	public InputConversionFile build() {
		return InstanceFactory.newInstance(this);
	}
}
