package de.mklinger.qetch.client.common;

import java.io.PrintWriter;
import java.io.StringWriter;

public class Throwables {
	/** No instantiation */
	private Throwables() {}

	public static String stackTraceToString(final Throwable e) {
		final StringWriter sw = new StringWriter();
		final PrintWriter pw = new PrintWriter(sw);
		e.printStackTrace(pw);
		pw.flush();
		return sw.toString();
	}

	@SuppressWarnings("unchecked")
	public static <T extends Throwable> T firstCause(final Throwable e, final Class<T> errorType) {
		if (e == null) {
			return null;
		}
		if (errorType.isAssignableFrom(e.getClass())) {
			return (T) e;
		} else {
			return firstCause(e.getCause(), errorType);
		}
	}

	public static boolean hasCause(final Throwable e, final Class<? extends Throwable> errorType) {
		return firstCause(e, errorType) != null;
	}
}
