/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.client.jetty.http2.client;

import de.mklinger.qetcher.client.jetty.http.MetaData;
import de.mklinger.qetcher.client.jetty.http2.ErrorCode;
import de.mklinger.qetcher.client.jetty.http2.FlowControlStrategy;
import de.mklinger.qetcher.client.jetty.http2.HTTP2Session;
import de.mklinger.qetcher.client.jetty.http2.IStream;
import de.mklinger.qetcher.client.jetty.http2.api.Session;
import de.mklinger.qetcher.client.jetty.http2.api.Stream;
import de.mklinger.qetcher.client.jetty.http2.frames.HeadersFrame;
import de.mklinger.qetcher.client.jetty.http2.frames.PushPromiseFrame;
import de.mklinger.qetcher.client.jetty.http2.generator.Generator;
import de.mklinger.qetcher.client.jetty.io.EndPoint;
import de.mklinger.qetcher.client.jetty.util.Callback;
import de.mklinger.qetcher.client.jetty.util.log.Log;
import de.mklinger.qetcher.client.jetty.util.log.Logger;
import de.mklinger.qetcher.client.jetty.util.thread.Scheduler;
import java.util.concurrent.atomic.AtomicLong;

public class HTTP2ClientSession
extends HTTP2Session {
    private static final Logger LOG = Log.getLogger(HTTP2ClientSession.class);
    private final AtomicLong streamsOpened = new AtomicLong();
    private final AtomicLong streamsClosed = new AtomicLong();

    public HTTP2ClientSession(Scheduler scheduler, EndPoint endPoint, Generator generator, Session.Listener listener, FlowControlStrategy flowControl) {
        super(scheduler, endPoint, generator, listener, flowControl, 1);
    }

    @Override
    protected void onStreamOpened(IStream stream) {
        super.onStreamOpened(stream);
        this.streamsOpened.incrementAndGet();
    }

    @Override
    protected void onStreamClosed(IStream stream) {
        super.onStreamClosed(stream);
        this.streamsClosed.incrementAndGet();
    }

    public long getStreamsOpened() {
        return this.streamsOpened.get();
    }

    public long getStreamsClosed() {
        return this.streamsClosed.get();
    }

    @Override
    public void onHeaders(HeadersFrame frame) {
        int streamId;
        IStream stream;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Received {}", frame);
        }
        if ((stream = this.getStream(streamId = frame.getStreamId())) != null) {
            MetaData metaData = frame.getMetaData();
            if (metaData.isRequest()) {
                this.onConnectionFailure(ErrorCode.PROTOCOL_ERROR.code, "invalid_response");
            } else {
                stream.process(frame, Callback.NOOP);
                this.notifyHeaders(stream, frame);
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Ignoring {}, stream #{} not found", frame, streamId);
        }
    }

    @Override
    public void onPushPromise(PushPromiseFrame frame) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Received {}", frame);
        }
        int streamId = frame.getStreamId();
        int pushStreamId = frame.getPromisedStreamId();
        IStream stream = this.getStream(streamId);
        if (stream == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Ignoring {}, stream #{} not found", frame, streamId);
            }
        } else {
            IStream pushStream = this.createRemoteStream(pushStreamId);
            pushStream.process(frame, Callback.NOOP);
            Stream.Listener listener = this.notifyPush(stream, pushStream, frame);
            pushStream.setListener(listener);
        }
    }

    private Stream.Listener notifyPush(IStream stream, IStream pushStream, PushPromiseFrame frame) {
        Stream.Listener listener = stream.getListener();
        if (listener == null) {
            return null;
        }
        try {
            return listener.onPush(pushStream, frame);
        }
        catch (Throwable x) {
            LOG.info("Failure while notifying listener " + listener, x);
            return null;
        }
    }
}

