/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.client.jackson.databind.ser.std;

import de.mklinger.qetcher.client.jackson.annotation.JsonFormat;
import de.mklinger.qetcher.client.jackson.core.JsonGenerator;
import de.mklinger.qetcher.client.jackson.core.JsonToken;
import de.mklinger.qetcher.client.jackson.core.type.WritableTypeId;
import de.mklinger.qetcher.client.jackson.databind.BeanProperty;
import de.mklinger.qetcher.client.jackson.databind.JsonMappingException;
import de.mklinger.qetcher.client.jackson.databind.JsonSerializer;
import de.mklinger.qetcher.client.jackson.databind.SerializationFeature;
import de.mklinger.qetcher.client.jackson.databind.SerializerProvider;
import de.mklinger.qetcher.client.jackson.databind.jsontype.TypeSerializer;
import de.mklinger.qetcher.client.jackson.databind.ser.ContainerSerializer;
import de.mklinger.qetcher.client.jackson.databind.ser.ContextualSerializer;
import java.io.IOException;

public abstract class ArraySerializerBase<T>
extends ContainerSerializer<T>
implements ContextualSerializer {
    protected final BeanProperty _property;
    protected final Boolean _unwrapSingle;

    protected ArraySerializerBase(Class<T> cls) {
        super(cls);
        this._property = null;
        this._unwrapSingle = null;
    }

    @Deprecated
    protected ArraySerializerBase(Class<T> cls, BeanProperty property) {
        super(cls);
        this._property = property;
        this._unwrapSingle = null;
    }

    protected ArraySerializerBase(ArraySerializerBase<?> src) {
        super(src._handledType, false);
        this._property = src._property;
        this._unwrapSingle = src._unwrapSingle;
    }

    protected ArraySerializerBase(ArraySerializerBase<?> src, BeanProperty property, Boolean unwrapSingle) {
        super(src._handledType, false);
        this._property = property;
        this._unwrapSingle = unwrapSingle;
    }

    @Deprecated
    protected ArraySerializerBase(ArraySerializerBase<?> src, BeanProperty property) {
        super(src._handledType, false);
        this._property = property;
        this._unwrapSingle = src._unwrapSingle;
    }

    public abstract JsonSerializer<?> _withResolved(BeanProperty var1, Boolean var2);

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider serializers, BeanProperty property) throws JsonMappingException {
        JsonFormat.Value format;
        Boolean unwrapSingle = null;
        if (property != null && (format = this.findFormatOverrides(serializers, property, this.handledType())) != null && (unwrapSingle = format.getFeature(JsonFormat.Feature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED)) != this._unwrapSingle) {
            return this._withResolved(property, unwrapSingle);
        }
        return this;
    }

    @Override
    public void serialize(T value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (this._shouldUnwrapSingle(provider) && this.hasSingleElement(value)) {
            this.serializeContents(value, gen, provider);
            return;
        }
        gen.setCurrentValue(value);
        gen.writeStartArray();
        this.serializeContents(value, gen, provider);
        gen.writeEndArray();
    }

    @Override
    public final void serializeWithType(T value, JsonGenerator g, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        g.setCurrentValue(value);
        WritableTypeId typeIdDef = typeSer.writeTypePrefix(g, typeSer.typeId(value, JsonToken.START_ARRAY));
        this.serializeContents(value, g, provider);
        typeSer.writeTypeSuffix(g, typeIdDef);
    }

    protected abstract void serializeContents(T var1, JsonGenerator var2, SerializerProvider var3) throws IOException;

    protected final boolean _shouldUnwrapSingle(SerializerProvider provider) {
        if (this._unwrapSingle == null) {
            return provider.isEnabled(SerializationFeature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED);
        }
        return this._unwrapSingle;
    }
}

