/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.liferay.client.impl.liferay71.scr;

import com.liferay.portal.kernel.util.PropsUtil;
import de.mklinger.micro.annotations.GuardedBy;
import de.mklinger.micro.annotations.VisibleForTesting;
import de.mklinger.qetcher.liferay.client.impl.liferay71.scr.FilterFactory;
import de.mklinger.qetcher.liferay.client.impl.liferay71.scr.PropertiesFiles;
import de.mklinger.qetcher.liferay.client.impl.liferay71.scr.ServiceAvailableTracker;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.runtime.ServiceComponentRuntime;
import org.osgi.service.component.runtime.dto.ComponentDescriptionDTO;
import org.osgi.service.component.runtime.dto.ReferenceDTO;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScrServiceOverride<T>
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(ScrServiceOverride.class);
    private static final Timer TIMER = new Timer("qetcher-service-override", true);
    private final BundleContext bundleContext;
    private final Class<T> serviceClass;
    private final String appliedTarget;
    private final Predicate<ServiceReference<T>> shouldApplyOverride;
    private final Consumer<ServiceReference<T>> onOverridingServiceAvailable;
    private final Runnable onOverridingServiceUnavailable;
    private final ServiceTracker<ServiceComponentRuntime, ServiceComponentRuntime> scrTracker;
    private final ServiceAvailableTracker<T> overridingServiceTracker;
    private final Object timerTaskMutex;
    @GuardedBy(value="timerTaskMutex")
    private TimerTask timerTask;
    private final List<Path> managedConfigFiles = new CopyOnWriteArrayList<Path>();

    public ScrServiceOverride(BundleContext bundleContext, Class<T> serviceClass, String filterKey, String filterValue) {
        this(bundleContext, serviceClass, filterKey, filterValue, null, null);
    }

    public ScrServiceOverride(BundleContext bundleContext, Class<T> serviceClass, String filterKey, String filterValue, Consumer<ServiceReference<T>> onOverridingServiceAvailable, Runnable onOverridingServiceUnavailable) {
        this.bundleContext = bundleContext;
        this.serviceClass = serviceClass;
        this.appliedTarget = FilterFactory.eq(filterKey, filterValue);
        this.shouldApplyOverride = sr -> !filterValue.equals(sr.getProperty(filterKey));
        this.onOverridingServiceAvailable = onOverridingServiceAvailable;
        this.onOverridingServiceUnavailable = onOverridingServiceUnavailable;
        this.timerTaskMutex = new Object();
        this.scrTracker = new ServiceTracker(bundleContext, ServiceComponentRuntime.class, null);
        this.scrTracker.open();
        Filter filter = FilterFactory.build(FilterFactory.and(FilterFactory.eq("objectClass", serviceClass.getName()), FilterFactory.eq(filterKey, filterValue)));
        this.overridingServiceTracker = new ServiceAvailableTracker(bundleContext, filter, this::onOverridingServiceAvailable, this::onOverridingServiceUnavailable);
        this.overridingServiceTracker.open(true);
    }

    @VisibleForTesting
    public void onOverridingServiceAvailable(ServiceReference<T> serviceReference) {
        if (this.onOverridingServiceAvailable != null) {
            this.onOverridingServiceAvailable.accept(serviceReference);
        }
        this.start();
    }

    @VisibleForTesting
    public void onOverridingServiceUnavailable() {
        if (this.onOverridingServiceUnavailable != null) {
            this.onOverridingServiceUnavailable.run();
        }
        this.stop();
    }

    private void start() {
        this.scheduleTimerAtFixedRate(this::apply, 0L, 30L, TimeUnit.SECONDS);
    }

    private void stop() {
        this.cancelTimerTask();
    }

    private void apply() {
        ServiceComponentRuntime serviceComponentRuntime = (ServiceComponentRuntime)this.scrTracker.getService();
        if (serviceComponentRuntime == null) {
            LOG.warn("Service component runtime not available");
            return;
        }
        this.getAllServiceReferencesForServiceClass().stream().filter(this.shouldApplyOverride).peek(serviceReference -> LOG.debug("Considering service reference {}", serviceReference)).map(ServiceReference::getUsingBundles).filter(Objects::nonNull).flatMap(Stream::of).distinct().peek(usingBundle -> LOG.debug("Considering bundle {}", usingBundle)).map(xva$0 -> serviceComponentRuntime.getComponentDescriptionDTOs(new Bundle[]{xva$0})).flatMap(Collection::stream).peek(componentDescriptionDTO -> LOG.debug("Considering component {}", (Object)componentDescriptionDTO.name)).map(componentDescriptionDTO -> MatchingReferences.map(componentDescriptionDTO, this::isMatchingReference)).filter(Optional::isPresent).map(Optional::get).forEach(this::applyComponentConfigurationIfNeeded);
    }

    private void applyComponentConfigurationIfNeeded(MatchingReferences matchingReferences) {
        String configFilename = matchingReferences.getComponentName() + ".cfg";
        Path configPath = Paths.get(PropsUtil.get((String)"liferay.home"), "osgi", "configs", configFilename);
        TreeMap<String, String> properties = new TreeMap<String, String>();
        for (String referenceName : matchingReferences.getReferenceNames()) {
            properties.put(referenceName + ".target", this.appliedTarget);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("********************");
            LOG.debug("* {} Override:", (Object)this.serviceClass.getSimpleName());
            LOG.debug("* Found SCR reference for service that should be overridden:");
            LOG.debug("* To override, use config file:");
            LOG.debug("* {}", (Object)configPath);
            LOG.debug("* with properties");
            LOG.debug("* {}", properties);
            LOG.debug("********************");
        }
        try {
            this.applyConfigProperties(configPath, properties);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void applyConfigProperties(Path configPath, TreeMap<String, String> properties) throws IOException {
        boolean store;
        if (Files.exists(configPath, new LinkOption[0])) {
            if (this.managedConfigFiles.contains(configPath)) {
                if (this.hasExpectedContents(configPath, properties)) {
                    LOG.debug("{} override: Managed config file exists and has expected contents. Nothing to be done: {}", (Object)this.serviceClass.getSimpleName(), (Object)configPath);
                    store = false;
                } else {
                    LOG.info("{} override: Updating managed config file: {}", (Object)this.serviceClass.getSimpleName(), (Object)configPath);
                    store = true;
                }
            } else {
                LOG.warn("{} override: Config file already exists, unable to override service: {}", (Object)this.serviceClass.getSimpleName(), (Object)configPath);
                store = false;
            }
        } else {
            LOG.info("{} override: Creating new managed config file: {}", (Object)this.serviceClass.getSimpleName(), (Object)configPath);
            store = true;
        }
        if (store) {
            PropertiesFiles.store(properties, configPath);
            this.managedConfigFiles.add(configPath);
        }
    }

    private boolean hasExpectedContents(Path configPath, TreeMap<String, String> expectedProperties) throws IOException {
        TreeMap actualProperties = PropertiesFiles.loadMap(configPath, TreeMap::new);
        return actualProperties.equals(expectedProperties);
    }

    private boolean isMatchingReference(ReferenceDTO reference) {
        if (!this.serviceClass.getName().equals(reference.interfaceName)) {
            return false;
        }
        if (reference.target == null) {
            return true;
        }
        if (this.appliedTarget.equals(reference.target)) {
            return false;
        }
        if (FilterFactory.not(this.appliedTarget).equals(reference.target)) {
            LOG.debug("{} override: Not overriding service reference {} that explicitly negates the override target: {}", new Object[]{this.serviceClass.getSimpleName(), reference.name, reference.target});
            return false;
        }
        LOG.warn("{} override: Not overriding service reference {} with target '{}'", new Object[]{this.serviceClass.getSimpleName(), reference.name, reference.target});
        return false;
    }

    private Collection<ServiceReference<T>> getAllServiceReferencesForServiceClass() {
        try {
            return this.bundleContext.getServiceReferences(this.serviceClass, null);
        }
        catch (InvalidSyntaxException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public void close() {
        this.overridingServiceTracker.close();
        this.stop();
        this.scrTracker.close();
        for (Path configFile : this.managedConfigFiles) {
            try {
                LOG.info("{} override: Deleting managed config file: {}", (Object)this.serviceClass.getSimpleName(), (Object)configFile);
                Files.delete(configFile);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelTimerTask() {
        Object object = this.timerTaskMutex;
        synchronized (object) {
            if (this.timerTask != null) {
                this.timerTask.cancel();
                this.timerTask = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleTimerAtFixedRate(final Runnable r, long initialDelay, long period, TimeUnit unit) {
        Object object = this.timerTaskMutex;
        synchronized (object) {
            this.cancelTimerTask();
            this.timerTask = new TimerTask(){

                @Override
                public void run() {
                    r.run();
                }
            };
            TIMER.scheduleAtFixedRate(this.timerTask, unit.toMillis(initialDelay), unit.toMillis(period));
        }
    }

    private static class MatchingReferences {
        private final ComponentDescriptionDTO component;
        private final List<ReferenceDTO> references;

        public MatchingReferences(ComponentDescriptionDTO component, List<ReferenceDTO> references) {
            this.component = component;
            this.references = references;
        }

        public static Optional<MatchingReferences> map(ComponentDescriptionDTO componentDescriptionDTO, Predicate<ReferenceDTO> predicate) {
            List<ReferenceDTO> matchingReferences = Stream.of(componentDescriptionDTO.references).filter(predicate).collect(Collectors.toList());
            if (matchingReferences.isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(new MatchingReferences(componentDescriptionDTO, matchingReferences));
        }

        public String getComponentName() {
            return this.component.name;
        }

        public List<String> getReferenceNames() {
            return this.references.stream().map(reference -> reference.name).collect(Collectors.toList());
        }
    }
}

