/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.liferay.client.impl.liferay71;

import com.liferay.document.library.kernel.exception.NoSuchFileEntryException;
import com.liferay.document.library.kernel.util.DLUtil;
import com.liferay.document.library.kernel.util.VideoProcessor;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import de.mklinger.qetcher.client.InputConversionFile;
import de.mklinger.qetcher.client.InputJob;
import de.mklinger.qetcher.client.model.v1.ConversionFile;
import de.mklinger.qetcher.client.model.v1.Job;
import de.mklinger.qetcher.client.model.v1.MediaType;
import de.mklinger.qetcher.liferay.client.QetcherClientService;
import de.mklinger.qetcher.liferay.client.QetcherConversionsService;
import de.mklinger.qetcher.liferay.client.impl.QetcherConfiguration;
import de.mklinger.qetcher.liferay.client.impl.QetcherJobs;
import de.mklinger.qetcher.liferay.client.impl.QetcherTimeoutConfig;
import de.mklinger.qetcher.liferay.client.impl.liferay71.ProcessorMediaTypes;
import de.mklinger.qetcher.liferay.client.impl.liferay71.QetcherVideoProcessorImplBoilerplate;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, property={"qetcher:Boolean=true", "service.ranking:Integer=1000"}, configurationPid={"de.mklinger.qetcher.liferay.client.impl.QetcherConfiguration"}, configurationPolicy=ConfigurationPolicy.REQUIRE)
public class QetcherVideoProcessorImpl
extends QetcherVideoProcessorImplBoilerplate
implements VideoProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(QetcherVideoProcessorImpl.class);
    private QetcherClientService qetcherClientService;
    private QetcherJobs qetcherJobs;
    private QetcherConversionsService qetcherConversionsService;
    private ProcessorMediaTypes processorMediaTypes;
    private QetcherTimeoutConfig timeoutConfig;
    private QetcherConfiguration qetcherConfiguration;

    @Reference
    public void setQetcherClientService(QetcherClientService qetcherClientService) {
        this.qetcherClientService = qetcherClientService;
    }

    @Reference
    public void setQetcherJobs(QetcherJobs qetcherJobs) {
        this.qetcherJobs = qetcherJobs;
    }

    @Reference
    public void setQetcherConversionsService(QetcherConversionsService qetcherConversionsService) {
        this.qetcherConversionsService = qetcherConversionsService;
    }

    @Reference
    public void setProcessorMediaTypes(ProcessorMediaTypes processorMediaTypes) {
        this.processorMediaTypes = processorMediaTypes;
    }

    @Reference
    public void setTimeoutConfig(QetcherTimeoutConfig timeoutConfig) {
        this.timeoutConfig = timeoutConfig;
    }

    @Activate
    @Modified
    public synchronized void activate(Map<String, Object> configurationProperties) {
        LOG.debug("Configuration was set");
        this.setQetcherConfiguration((QetcherConfiguration)ConfigurableUtil.createConfigurable(QetcherConfiguration.class, configurationProperties));
        super.afterPropertiesSet();
    }

    private void setQetcherConfiguration(QetcherConfiguration qetcherConfiguration) {
        this.qetcherConfiguration = qetcherConfiguration;
    }

    public Set<String> getVideoMimeTypes() {
        if (this.qetcherConfiguration.useAllSupportedVideoTypes()) {
            return this.qetcherConversionsService.getSourceMediaTypesForRegistry("video");
        }
        return this.liferayVideoMimeTypes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateVideo(FileVersion sourceFileVersion, FileVersion destinationFileVersion) throws Exception {
        block26: {
            if (this._hasVideo(destinationFileVersion)) {
                return;
            }
            AtomicReference conversionFile = new AtomicReference();
            ArrayList<Job> jobs = new ArrayList<Job>();
            ArrayList<Path> tempFiles = new ArrayList<Path>();
            try {
                String tempFileId;
                if (sourceFileVersion != null) {
                    this.copy(sourceFileVersion, destinationFileVersion);
                    return;
                }
                if (this.hasPreviews(destinationFileVersion) && this.hasThumbnails(destinationFileVersion)) break block26;
                MediaType fromMediaType = this.processorMediaTypes.getMediaType(destinationFileVersion);
                LOG.info("Uploading file version {} with media type {}", (Object)destinationFileVersion.getFileVersionId(), (Object)fromMediaType);
                InputStream inputStream = this.getContentStream(destinationFileVersion);
                Object tempFile = null;
                try {
                    String[] inputConversionFile = this.qetcherClientService.inputFileFor(inputStream).mediaType(fromMediaType).deleteTimeout(this.timeoutConfig.getFileServiceDeleteTimeout().toDuration()).build();
                    conversionFile.set(this.qetcherClientService.client().uploadFile((InputConversionFile)inputConversionFile).join());
                }
                catch (Throwable inputConversionFile) {
                    tempFile = inputConversionFile;
                    throw inputConversionFile;
                }
                finally {
                    if (inputStream != null) {
                        if (tempFile != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable inputConversionFile) {
                                ((Throwable)tempFile).addSuppressed(inputConversionFile);
                            }
                        } else {
                            inputStream.close();
                        }
                    }
                }
                ArrayList<CompletionStage> jobFutures = new ArrayList<CompletionStage>();
                if (!this.hasPreviews(destinationFileVersion)) {
                    tempFileId = DLUtil.getTempFileId((long)destinationFileVersion.getFileEntryId(), (String)destinationFileVersion.getVersion());
                    for (String previewType : _PREVIEW_TYPES) {
                        MediaType toMediaType = this.processorMediaTypes.getContainerMediaType(previewType);
                        String referrer = "liferay-videoprocessor-id=" + tempFileId + ";liferay-videoprocessor-type=" + previewType;
                        Job job = this.newJob((ConversionFile)conversionFile.get(), toMediaType, referrer);
                        jobs.add(job);
                        Path targetFile = this.getPreviewTempFile(tempFileId, previewType).toPath();
                        tempFiles.add(targetFile);
                        CompletionStage jobFuture = this.runJob(job, targetFile).thenRunAsync(() -> this.addFileToStore(destinationFileVersion.getCompanyId(), "document_preview/", this.getPreviewFilePath(destinationFileVersion, previewType), targetFile));
                        jobFutures.add(jobFuture);
                    }
                }
                if (!this.hasThumbnails(destinationFileVersion)) {
                    tempFileId = DLUtil.getTempFileId((long)destinationFileVersion.getFileEntryId(), (String)destinationFileVersion.getVersion());
                    Path thumbnailTempFile = this.getThumbnailTempFile(tempFileId).toPath();
                    tempFiles.add(thumbnailTempFile);
                    MediaType toMediaType = this.processorMediaTypes.getContainerMediaType("jpg").withParameter("offset", this.getThumbnailOffset());
                    String referrer = "liferay-videoprocessor-id=" + tempFileId + ";liferay-videoprocessor-type=" + "jpg";
                    Job job = this.newJob((ConversionFile)conversionFile.get(), toMediaType, referrer);
                    jobs.add(job);
                    CompletionStage jobFuture = this.runJob(job, thumbnailTempFile).thenRunAsync(() -> this.storeThumbnailImages(destinationFileVersion, thumbnailTempFile));
                    jobFutures.add(jobFuture);
                }
                jobFutures.forEach(cf -> {
                    Void cfr_ignored_0 = (Void)((CompletableFuture)cf.exceptionally(e -> {
                        LOG.error("Error executing video processor job", e);
                        return null;
                    })).join();
                });
            }
            catch (NoSuchFileEntryException nsfee) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("File entry not found", (Throwable)nsfee);
                }
            }
            finally {
                this._fileVersionIds.remove(destinationFileVersion.getFileVersionId());
                ArrayList jobDeleteFutures = new ArrayList(jobs.size());
                for (Job job : jobs) {
                    CompletableFuture jobDeleteFuture = this.qetcherClientService.client().deleteJob(job);
                    jobDeleteFutures.add(jobDeleteFuture);
                }
                ((CompletableFuture)((CompletableFuture)QetcherVideoProcessorImpl.allOf(jobDeleteFutures).exceptionally(e -> {
                    LOG.error("Error deleting job(s)", e);
                    return null;
                })).thenCompose(__ -> this.qetcherClientService.client().deleteFile((ConversionFile)conversionFile.get()))).exceptionally(e -> {
                    LOG.error("Error deleting file", e);
                    return null;
                });
                for (Path tempFile : tempFiles) {
                    FileUtil.delete((File)tempFile.toFile());
                }
            }
        }
    }

    public static <T> CompletableFuture<Void> allOf(List<CompletableFuture<T>> cfs) {
        return CompletableFuture.allOf(cfs.toArray(new CompletableFuture[cfs.size()]));
    }

    private InputStream getContentStream(FileVersion fileVersion) {
        try {
            return fileVersion.getContentStream(false);
        }
        catch (PortalException e) {
            throw new RuntimeException(e);
        }
    }

    private Job newJob(ConversionFile conversionFile, MediaType toMediaType, String referrer) {
        LOG.info("Creating video processing job to {} with referrer '{}'", (Object)toMediaType, (Object)referrer);
        InputJob inputJob = this.qetcherClientService.job().fromFile(conversionFile).fromMediaType(conversionFile.getMediaType()).toMediaType(toMediaType).referrer(referrer).cancelTimeout(this.timeoutConfig.getJobServiceCancelTimeout().toDuration()).deleteTimeout(this.timeoutConfig.getJobServiceDeleteTimeout().toDuration()).build();
        return this.qetcherJobs.createJobWithTimeout(inputJob).join();
    }

    private CompletableFuture<Path> runJob(Job job, Path targetFile) {
        return ((CompletableFuture)((CompletableFuture)this.qetcherJobs.getJobDoneWithTimeout(job).thenApply(this.qetcherJobs::requireSuccess)).thenApply(this.qetcherJobs::getSingleResultFileId)).thenCompose(fileId -> this.qetcherClientService.client().downloadAsFile(fileId, targetFile));
    }

    private void addFileToStore(long companyId, String previewPath, String previewFilePath, Path targetFile) {
        try {
            this.addFileToStore(companyId, previewPath, previewFilePath, targetFile.toFile());
        }
        catch (PortalException e) {
            throw new RuntimeException(e);
        }
    }

    private String getThumbnailOffset() {
        return GetterUtil.getInteger((String)PropsUtil.get((String)"dl.file.entry.thumbnail.video.frame.percentage"), (int)25) + "%";
    }

    private void storeThumbnailImages(FileVersion destinationFileVersion, Path thumbnailTempFile) {
        try {
            this.storeThumbnailImages(destinationFileVersion, thumbnailTempFile.toFile());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

