/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.liferay.client.impl.liferay71;

import de.mklinger.qetcher.client.QetcherClientException;
import de.mklinger.qetcher.liferay.client.impl.QetcherTimeoutConfig;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={QetcherTimeoutGet.class})
public class QetcherTimeoutGet {
    @Reference
    private QetcherTimeoutConfig timeoutConfig;

    public <T> T getWithShortTimeout(CompletableFuture<T> future) {
        return this.get(future, this.timeoutConfig.getShortTimeout());
    }

    public <T> T getWithUploadTimeout(CompletableFuture<T> future) {
        return this.get(future, this.timeoutConfig.getUploadTimeout());
    }

    public <T> T getWithDownloadTimeout(CompletableFuture<T> future) {
        return this.get(future, this.timeoutConfig.getDownloadTimeout());
    }

    private <T> T get(CompletableFuture<T> future, QetcherTimeoutConfig.TimeValue timeout) {
        return this.get(future, timeout.time(), timeout.unit());
    }

    private <T> T get(CompletableFuture<T> future, long timeout, TimeUnit timeoutUnit) {
        try {
            return future.get(timeout, timeoutUnit);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new QetcherClientException("Qetcher client interrupted", (Throwable)e);
        }
        catch (TimeoutException e) {
            throw new QetcherClientException("Qetcher client timeout after " + timeout + " " + (Object)((Object)timeoutUnit), (Throwable)e);
        }
        catch (ExecutionException e) {
            throw new QetcherClientException("Qetcher client error", (Throwable)e);
        }
    }
}

