/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.liferay.client.impl.liferay71;

import com.liferay.portal.kernel.metadata.RawMetadataProcessor;
import com.liferay.portal.kernel.metadata.RawMetadataProcessorUtil;
import de.mklinger.micro.annotations.VisibleForTesting;
import de.mklinger.qetcher.liferay.client.impl.liferay71.scr.ScrServiceOverride;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class QetcherRawMetadataProcessorServiceOverride {
    private static final Logger LOG = LoggerFactory.getLogger(QetcherRawMetadataProcessorServiceOverride.class);
    private BundleContext bundleContext;
    private ScrServiceOverride<RawMetadataProcessor> serviceOverride;
    private RawMetadataProcessor originalService;
    private ServiceReference<RawMetadataProcessor> overridingServiceRef;

    @Activate
    public synchronized void activate(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.serviceOverride = new ScrServiceOverride<RawMetadataProcessor>(bundleContext, RawMetadataProcessor.class, "qetcher", "true", this::onOverridingServiceAvailable, this::onOverridingServiceUnavailable);
    }

    @Deactivate
    public synchronized void deactivate() {
        ScrServiceOverride<RawMetadataProcessor> override = this.serviceOverride;
        this.serviceOverride = null;
        override.close();
    }

    protected synchronized void onOverridingServiceAvailable(ServiceReference<RawMetadataProcessor> overridingServiceRef) {
        if (this.originalService != null) {
            throw new IllegalStateException();
        }
        if (this.overridingServiceRef != null) {
            throw new IllegalStateException();
        }
        this.overridingServiceRef = overridingServiceRef;
        RawMetadataProcessor overridingService = (RawMetadataProcessor)this.bundleContext.getService(overridingServiceRef);
        if (overridingService == null) {
            LOG.warn("Service unavailable");
        } else {
            LOG.info("Using service for {}: {}", (Object)RawMetadataProcessorUtil.class.getSimpleName(), (Object)overridingService);
            this.originalService = RawMetadataProcessorUtil.getRawMetadataProcessor();
            new RawMetadataProcessorUtil().setRawMetadataProcessor(overridingService);
        }
    }

    protected synchronized void onOverridingServiceUnavailable() {
        if (this.originalService == null) {
            LOG.warn("Unable to restore original service for {}", (Object)RawMetadataProcessorUtil.class.getSimpleName());
        } else {
            LOG.info("Restoring original service for {}: {}", (Object)RawMetadataProcessorUtil.class.getSimpleName(), (Object)this.originalService);
            new RawMetadataProcessorUtil().setRawMetadataProcessor(this.originalService);
            this.originalService = null;
        }
        this.bundleContext.ungetService(this.overridingServiceRef);
    }

    @VisibleForTesting
    protected ScrServiceOverride<RawMetadataProcessor> getServiceOverride() {
        return this.serviceOverride;
    }
}

