/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.liferay.client.impl.liferay71;

import com.liferay.portal.kernel.util.MimeTypes;
import de.mklinger.micro.annotations.Nullable;
import de.mklinger.qetcher.client.model.v1.FileExtensionInfos;
import de.mklinger.qetcher.client.model.v1.MediaType;
import de.mklinger.qetcher.client.model.v1.MediaTypeInfo;
import de.mklinger.qetcher.liferay.abstraction.CacheTool;
import de.mklinger.qetcher.liferay.client.QetcherClientService;
import de.mklinger.qetcher.liferay.client.impl.liferay71.QetcherTimeoutGet;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, property={"qetcher:Boolean=true", "service.ranking:Integer=1000"})
public class QetcherMimeTypesImpl
implements MimeTypes {
    private static final String APPLICATION_OCTETSTREAM = "application/octet-stream";
    private static final String CACHE_NAME = "de.mklinger.qetcher.liferay.MimeTypesCache";
    private static final String FILEEXTENSION_INFOS_KEY = "mediaTypesByExtension";
    private static final String EXTENSIONS_BY_MEDIATYPE_KEY = "extensionsByMediaType";
    private static final String UNUSABLEFILENAME = "unusablefilename";
    private static final boolean PREFER_QETCHER_FILENAME_MEDIA_TYPE = true;
    private static final Logger LOG = LoggerFactory.getLogger(QetcherMimeTypesImpl.class);
    private QetcherClientService qetcherClientService;
    private QetcherTimeoutGet timeoutGet;
    private CacheTool cacheTool;
    private MimeTypes liferayMimeTypes;

    @Reference
    public void setQetcherClientService(QetcherClientService qetcherClientService) {
        this.qetcherClientService = qetcherClientService;
    }

    @Reference
    public void setTimeoutGet(QetcherTimeoutGet timeoutGet) {
        this.timeoutGet = timeoutGet;
    }

    @Reference
    public void setCacheTool(CacheTool cacheTool) {
        this.cacheTool = cacheTool;
    }

    @Reference(target="(!(qetcher=true))")
    public void setLiferayMimeTypes(MimeTypes liferayMimeTypes) {
        this.liferayMimeTypes = liferayMimeTypes;
    }

    public String getContentType(File file) {
        Optional<String> contentType = this.getQetcherFilenameContentType(file.getName());
        if (contentType.isPresent()) {
            return contentType.get();
        }
        return this.getFileContentType(file).orElseGet(() -> this.getFilenameContentType(file.getName()));
    }

    public String getContentType(File file, String fileName) {
        if (file != null || fileName != null) {
            Optional<String> contentType;
            String actualFileName = fileName;
            if (actualFileName == null) {
                actualFileName = file.getName();
            }
            if ((contentType = this.getQetcherFilenameContentType(actualFileName)).isPresent()) {
                return contentType.get();
            }
        }
        return this.getFileContentType(file).orElseGet(() -> this.getFilenameContentType(fileName));
    }

    public String getContentType(InputStream inputStream, String fileName) {
        Optional<String> contentType;
        if (fileName != null && (contentType = this.getQetcherFilenameContentType(fileName)).isPresent()) {
            return contentType.get();
        }
        return this.getInputStreamContentType(inputStream).orElseGet(() -> this.getFilenameContentType(fileName));
    }

    public String getContentType(String fileName) {
        return this.getFilenameContentType(fileName);
    }

    public boolean isWebImage(String mimeType) {
        return this.liferayMimeTypes.isWebImage(mimeType);
    }

    protected Optional<String> getFileContentType(@Nullable File file) {
        if (file == null || !file.exists()) {
            return Optional.empty();
        }
        String contentType = this.liferayMimeTypes.getContentType(file, UNUSABLEFILENAME);
        if (contentType == null || contentType.isEmpty() || APPLICATION_OCTETSTREAM.equals(contentType)) {
            return Optional.empty();
        }
        LOG.info("Have content type by file contents for file name {}: {}", (Object)file.getName(), (Object)contentType);
        return Optional.of(contentType);
    }

    protected Optional<String> getInputStreamContentType(@Nullable InputStream in) {
        if (in == null) {
            return Optional.empty();
        }
        String contentType = this.liferayMimeTypes.getContentType(in, UNUSABLEFILENAME);
        if (contentType == null || contentType.isEmpty() || APPLICATION_OCTETSTREAM.equals(contentType)) {
            return Optional.empty();
        }
        LOG.debug("Have content type by input stream contents: {}", (Object)contentType);
        return Optional.of(contentType);
    }

    public String getExtensionContentType(@Nullable String extension) {
        if (extension == null || extension.isEmpty()) {
            return this.liferayMimeTypes.getExtensionContentType(extension);
        }
        FileExtensionInfos fileExtensions = this.getFileExtensions();
        return fileExtensions.getMediaType(extension).map(mediaType -> {
            LOG.debug("Using media type from Qetcher for extension '{}': '{}'", (Object)extension, mediaType);
            return mediaType;
        }).map(MediaType::getFullType).orElseGet(() -> this.liferayMimeTypes.getExtensionContentType(extension));
    }

    private String getFilenameContentType(@Nullable String filename) {
        if (filename == null || filename.isEmpty()) {
            return this.liferayMimeTypes.getContentType(filename);
        }
        return this.getQetcherFilenameContentType(filename).orElseGet(() -> this.liferayMimeTypes.getContentType(filename));
    }

    private Optional<String> getQetcherFilenameContentType(String filename) {
        Objects.requireNonNull(filename);
        FileExtensionInfos fileExtensions = this.getFileExtensions();
        List<String> extensions = this.getFilenameExtensions(filename);
        for (String extension : extensions) {
            Optional mediaType = fileExtensions.getMediaType(extension);
            if (!mediaType.isPresent()) continue;
            LOG.debug("Using media type from Qetcher for filename '{}': '{}'", (Object)filename, mediaType.get());
            return Optional.of(((MediaType)mediaType.get()).getFullType());
        }
        return Optional.empty();
    }

    protected List<String> getFilenameExtensions(String filename) {
        int idx;
        Objects.requireNonNull(filename);
        String simpleName = FilenameUtils.getName((String)filename);
        ArrayList<String> extensions = new ArrayList<String>(2);
        int startIdx = 0;
        while (simpleName.length() > startIdx && (idx = simpleName.indexOf(46, startIdx)) != -1 && simpleName.length() > idx + 1) {
            String extension = simpleName.substring(idx + 1);
            if (extension.length() > 0 && !extension.startsWith(".")) {
                extensions.add(extension);
            }
            startIdx = idx + 1;
        }
        return extensions;
    }

    public Set<String> getExtensions(String contentType) {
        LinkedHashSet<String> extensions = this.getExtensionsByMediaType().get(contentType.toLowerCase());
        if (extensions != null) {
            return extensions;
        }
        return this.liferayMimeTypes.getExtensions(contentType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileExtensionInfos getFileExtensions() {
        FileExtensionInfos fileExtensions = this.getFileExtensionsFromCache();
        if (fileExtensions == null) {
            QetcherMimeTypesImpl qetcherMimeTypesImpl = this;
            synchronized (qetcherMimeTypesImpl) {
                fileExtensions = this.getFileExtensionsFromCache();
                if (fileExtensions == null) {
                    fileExtensions = this.loadFileExtensions();
                    this.putFileExtensionsToCache(fileExtensions);
                }
            }
        }
        return fileExtensions;
    }

    private FileExtensionInfos getFileExtensionsFromCache() {
        try {
            Object[] serializable = (Object[])this.cacheTool.get(CACHE_NAME, FILEEXTENSION_INFOS_KEY);
            if (serializable == null) {
                LOG.debug("Cache miss for {}", (Object)FILEEXTENSION_INFOS_KEY);
                return null;
            }
            LOG.debug("Cache hit for {}", (Object)FILEEXTENSION_INFOS_KEY);
            return (FileExtensionInfos)serializable[0];
        }
        catch (Exception e) {
            LOG.warn("Error accessing cache", (Throwable)e);
            return null;
        }
    }

    private FileExtensionInfos loadFileExtensions() {
        LOG.info("Loading file extensions");
        return (FileExtensionInfos)this.timeoutGet.getWithShortTimeout(this.qetcherClientService.client().getFileExtensions());
    }

    private void putFileExtensionsToCache(FileExtensionInfos o) {
        Object[] serializable = new Object[]{o};
        this.cacheTool.put(CACHE_NAME, FILEEXTENSION_INFOS_KEY, (Serializable)serializable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, LinkedHashSet<String>> getExtensionsByMediaType() {
        Map<String, LinkedHashSet<String>> fileExtensions = this.getExtensionsByMediaTypeFromCache();
        if (fileExtensions == null) {
            QetcherMimeTypesImpl qetcherMimeTypesImpl = this;
            synchronized (qetcherMimeTypesImpl) {
                fileExtensions = this.getExtensionsByMediaTypeFromCache();
                if (fileExtensions == null) {
                    fileExtensions = this.loadExtensionsByMediaType();
                    this.putExtensionsByMediaTypeToCache(fileExtensions);
                }
            }
        }
        return fileExtensions;
    }

    private Map<String, LinkedHashSet<String>> getExtensionsByMediaTypeFromCache() {
        try {
            Object[] serializable = (Object[])this.cacheTool.get(CACHE_NAME, EXTENSIONS_BY_MEDIATYPE_KEY);
            if (serializable == null) {
                LOG.debug("Cache miss for {}", (Object)EXTENSIONS_BY_MEDIATYPE_KEY);
                return null;
            }
            LOG.debug("Cache hit for {}", (Object)EXTENSIONS_BY_MEDIATYPE_KEY);
            return (Map)serializable[0];
        }
        catch (Exception e) {
            LOG.warn("Error accessing cache", (Throwable)e);
            return null;
        }
    }

    private Map<String, LinkedHashSet<String>> loadExtensionsByMediaType() {
        LOG.info("Loading media type infos");
        List mediaTypes = (List)this.timeoutGet.getWithShortTimeout(this.qetcherClientService.client().getMediaTypes());
        return this.toExtensionsByMediaType(mediaTypes);
    }

    protected Map<String, LinkedHashSet<String>> toExtensionsByMediaType(List<MediaTypeInfo> mediaTypes) {
        List extensions;
        HashMap<String, LinkedHashSet<String>> m = QetcherMimeTypesImpl.newHashMap(mediaTypes.size());
        for (MediaTypeInfo mediaTypeInfo : mediaTypes) {
            extensions = mediaTypeInfo.getExtensions();
            if (extensions == null || extensions.isEmpty()) continue;
            List<String> extensionsWithLeadingDot = this.addLeadingDot(extensions);
            String mediaTypeString = mediaTypeInfo.getMediaType().getFullType().toLowerCase();
            m.computeIfAbsent(mediaTypeString, s -> new LinkedHashSet()).addAll(extensionsWithLeadingDot);
        }
        for (MediaTypeInfo mediaTypeInfo : mediaTypes) {
            extensions = mediaTypeInfo.getExtensions();
            List aliases = mediaTypeInfo.getAliases();
            if (extensions == null || extensions.isEmpty() || aliases == null || aliases.isEmpty()) continue;
            List<String> extensionsWithLeadingDot = this.addLeadingDot(extensions);
            for (MediaType alias : aliases) {
                String mediaTypeString = alias.getFullType().toLowerCase();
                m.computeIfAbsent(mediaTypeString, s -> new LinkedHashSet()).addAll(extensionsWithLeadingDot);
            }
        }
        return m;
    }

    private List<String> addLeadingDot(List<String> extensions) {
        return extensions.stream().map(extension -> ".".concat((String)extension)).collect(Collectors.toList());
    }

    private static <K, V> HashMap<K, V> newHashMap(int expectedSize) {
        return new HashMap(Math.max((int)((float)expectedSize / 0.75f) + 1, 4));
    }

    private void putExtensionsByMediaTypeToCache(Map<String, LinkedHashSet<String>> o) {
        Object[] serializable = new Object[]{o};
        this.cacheTool.put(CACHE_NAME, EXTENSIONS_BY_MEDIATYPE_KEY, (Serializable)serializable);
    }
}

