/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.liferay.client.impl.liferay71;

import com.liferay.portal.kernel.util.File;
import com.liferay.portal.kernel.util.FileUtil;
import de.mklinger.qetcher.liferay.client.impl.liferay71.scr.ScrServiceOverride;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class QetcherFileServiceOverride {
    private static final Logger LOG = LoggerFactory.getLogger(QetcherFileServiceOverride.class);
    private BundleContext bundleContext;
    private ScrServiceOverride<File> serviceOverride;
    private File originalService;
    private ServiceReference<File> overridingServiceRef;

    @Activate
    public synchronized void activate(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.serviceOverride = new ScrServiceOverride<File>(bundleContext, File.class, "qetcher", "true", this::onOverridingServiceAvailable, this::onOverridingServiceUnavailable);
    }

    @Deactivate
    public synchronized void deactivate() {
        ScrServiceOverride<File> override = this.serviceOverride;
        this.serviceOverride = null;
        override.close();
    }

    protected synchronized void onOverridingServiceAvailable(ServiceReference<File> overridingServiceRef) {
        if (this.originalService != null) {
            throw new IllegalStateException();
        }
        if (this.overridingServiceRef != null) {
            throw new IllegalStateException();
        }
        this.overridingServiceRef = overridingServiceRef;
        File overridingService = (File)this.bundleContext.getService(overridingServiceRef);
        if (overridingService == null) {
            LOG.warn("Service unavailable");
        } else {
            LOG.info("Using service for {}: {}", (Object)FileUtil.class.getSimpleName(), (Object)overridingService);
            this.originalService = FileUtil.getFile();
            new FileUtil().setFile(overridingService);
        }
    }

    protected synchronized void onOverridingServiceUnavailable() {
        if (this.originalService == null) {
            LOG.warn("Unable to restore original service for {}", (Object)FileUtil.class.getSimpleName());
        } else {
            LOG.info("Restoring original service for {}: {}", (Object)FileUtil.class.getSimpleName(), (Object)this.originalService);
            new FileUtil().setFile(this.originalService);
            this.originalService = null;
        }
        this.bundleContext.ungetService(this.overridingServiceRef);
    }
}

