/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.liferay.client.impl.liferay71;

import de.mklinger.qetcher.client.model.v1.MediaType;
import de.mklinger.qetcher.client.model.v1.MediaTypes;
import de.mklinger.qetcher.liferay.client.QetcherService;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Properties;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, property={"qetcher:Boolean=true", "service.ranking:Integer=1000"})
public class QetcherFileImpl
implements com.liferay.portal.kernel.util.File {
    private static final MediaType TEXT_FROM = MediaType.valueOf((String)"application/octet-stream");
    private static final MediaType TEXT_TO = MediaTypes.TXT.withParameter("ocrIfAvailable", "true");
    private static final Logger LOG = LoggerFactory.getLogger(QetcherFileImpl.class);
    private com.liferay.portal.kernel.util.File liferayFile;
    private QetcherService qetcherService;

    @Reference(target="(!(qetcher=true))")
    public void setLiferayFile(com.liferay.portal.kernel.util.File liferayFile) {
        this.liferayFile = liferayFile;
    }

    @Reference
    public void setQetcherService(QetcherService qetcherService) {
        this.qetcherService = qetcherService;
    }

    public String extractText(InputStream is, String fileName) {
        return this.extractText(is, fileName, -1);
    }

    public String extractText(InputStream is, String fileName, int maxStringLength) {
        try {
            return this.doExtractText(is, fileName, maxStringLength);
        }
        catch (Exception e) {
            LOG.warn("Error extracting text from file with name '{}' using Qetcher", (Object)fileName, (Object)e);
            return "";
        }
    }

    private String doExtractText(InputStream is, String fileName, int maxStringLength) {
        if (maxStringLength == 0) {
            return "";
        }
        String referrer = "liferay-extract-text-filename=" + fileName;
        LOG.info("Starting text extraction for file with name '{}'", (Object)fileName);
        byte[] text = this.qetcherService.convertToByteArray(is, TEXT_FROM, TEXT_TO, referrer);
        if (maxStringLength > 0 && text.length > maxStringLength) {
            return new String(text, 0, maxStringLength, StandardCharsets.UTF_8);
        }
        return new String(text, StandardCharsets.UTF_8);
    }

    public String appendParentheticalSuffix(String fileName, String suffix) {
        return this.liferayFile.appendParentheticalSuffix(fileName, suffix);
    }

    public String appendSuffix(String fileName, String suffix) {
        return this.liferayFile.appendSuffix(fileName, suffix);
    }

    public void copyDirectory(File source, File destination) throws IOException {
        this.liferayFile.copyDirectory(source, destination);
    }

    public void copyDirectory(String sourceDirName, String destinationDirName) throws IOException {
        this.liferayFile.copyDirectory(sourceDirName, destinationDirName);
    }

    public void copyFile(File source, File destination) throws IOException {
        this.liferayFile.copyFile(source, destination);
    }

    public void copyFile(File source, File destination, boolean lazy) throws IOException {
        this.liferayFile.copyFile(source, destination, lazy);
    }

    public void copyFile(String source, String destination) throws IOException {
        this.liferayFile.copyFile(source, destination);
    }

    public void copyFile(String source, String destination, boolean lazy) throws IOException {
        this.liferayFile.copyFile(source, destination, lazy);
    }

    public File createTempFile() {
        return this.liferayFile.createTempFile();
    }

    public File createTempFile(byte[] bytes) throws IOException {
        return this.liferayFile.createTempFile(bytes);
    }

    public File createTempFile(InputStream is) throws IOException {
        return this.liferayFile.createTempFile(is);
    }

    public File createTempFile(String extension) {
        return this.liferayFile.createTempFile(extension);
    }

    public File createTempFile(String prefix, String extension) {
        return this.liferayFile.createTempFile(prefix, extension);
    }

    public String createTempFileName() {
        return this.liferayFile.createTempFileName();
    }

    public String createTempFileName(String extension) {
        return this.liferayFile.createTempFileName(extension);
    }

    public String createTempFileName(String prefix, String extension) {
        return this.liferayFile.createTempFileName(prefix, extension);
    }

    public File createTempFolder() throws IOException {
        return this.liferayFile.createTempFolder();
    }

    public String decodeSafeFileName(String fileName) {
        return this.liferayFile.decodeSafeFileName(fileName);
    }

    public boolean delete(File file) {
        return this.liferayFile.delete(file);
    }

    public boolean delete(String file) {
        return this.liferayFile.delete(file);
    }

    public void deltree(File directory) {
        this.liferayFile.deltree(directory);
    }

    public void deltree(String directory) {
        this.liferayFile.deltree(directory);
    }

    public String encodeSafeFileName(String fileName) {
        return this.liferayFile.encodeSafeFileName(fileName);
    }

    public boolean exists(File file) {
        return this.liferayFile.exists(file);
    }

    public boolean exists(String fileName) {
        return this.liferayFile.exists(fileName);
    }

    public String[] find(String directory, String includes, String excludes) {
        return this.liferayFile.find(directory, includes, excludes);
    }

    public String getAbsolutePath(File file) {
        return this.liferayFile.getAbsolutePath(file);
    }

    public byte[] getBytes(Class<?> clazz, String fileName) throws IOException {
        return this.liferayFile.getBytes(clazz, fileName);
    }

    public byte[] getBytes(InputStream is) throws IOException {
        return this.liferayFile.getBytes(is);
    }

    public byte[] getBytes(InputStream is, int bufferSize) throws IOException {
        return this.liferayFile.getBytes(is, bufferSize);
    }

    public byte[] getBytes(InputStream inputStream, int bufferSize, boolean cleanUpStream) throws IOException {
        return this.liferayFile.getBytes(inputStream, bufferSize, cleanUpStream);
    }

    public byte[] getBytes(File file) throws IOException {
        return this.liferayFile.getBytes(file);
    }

    public String getExtension(String fileName) {
        return this.liferayFile.getExtension(fileName);
    }

    public String getMD5Checksum(File file) throws IOException {
        return this.liferayFile.getMD5Checksum(file);
    }

    public String getPath(String fullFileName) {
        return this.liferayFile.getPath(fullFileName);
    }

    public String getShortFileName(String fullFileName) {
        return this.liferayFile.getShortFileName(fullFileName);
    }

    public boolean isAscii(File file) throws IOException {
        return this.liferayFile.isAscii(file);
    }

    public boolean isSameContent(File file, byte[] bytes, int length) {
        return this.liferayFile.isSameContent(file, bytes, length);
    }

    public boolean isSameContent(File file, String s) {
        return this.liferayFile.isSameContent(file, s);
    }

    public String[] listDirs(File file) {
        return this.liferayFile.listDirs(file);
    }

    public String[] listDirs(String fileName) {
        return this.liferayFile.listDirs(fileName);
    }

    public String[] listFiles(File file) {
        return this.liferayFile.listFiles(file);
    }

    public String[] listFiles(String fileName) {
        return this.liferayFile.listFiles(fileName);
    }

    public void mkdirs(File file) throws IOException {
        this.liferayFile.mkdirs(file);
    }

    public void mkdirs(String pathName) {
        this.liferayFile.mkdirs(pathName);
    }

    public boolean move(File source, File destination) {
        return this.liferayFile.move(source, destination);
    }

    public boolean move(String sourceFileName, String destinationFileName) {
        return this.liferayFile.move(sourceFileName, destinationFileName);
    }

    public String read(File file) throws IOException {
        return this.liferayFile.read(file);
    }

    public String read(File file, boolean raw) throws IOException {
        return this.liferayFile.read(file, raw);
    }

    public String read(String fileName) throws IOException {
        return this.liferayFile.read(fileName);
    }

    public String replaceSeparator(String fileName) {
        return this.liferayFile.replaceSeparator(fileName);
    }

    public File[] sortFiles(File[] files) {
        return this.liferayFile.sortFiles(files);
    }

    public String stripExtension(String fileName) {
        return this.liferayFile.stripExtension(fileName);
    }

    public String stripParentheticalSuffix(String fileName) {
        return this.liferayFile.stripParentheticalSuffix(fileName);
    }

    public List<String> toList(Reader reader) {
        return this.liferayFile.toList(reader);
    }

    public List<String> toList(String fileName) {
        return this.liferayFile.toList(fileName);
    }

    public Properties toProperties(FileInputStream fis) {
        return this.liferayFile.toProperties(fis);
    }

    public Properties toProperties(String fileName) {
        return this.liferayFile.toProperties(fileName);
    }

    public void touch(File file) throws IOException {
        this.liferayFile.touch(file);
    }

    public void touch(String fileName) throws IOException {
        this.liferayFile.touch(fileName);
    }

    public void unzip(File source, File destination) {
        this.liferayFile.unzip(source, destination);
    }

    public void write(File file, byte[] bytes) throws IOException {
        this.liferayFile.write(file, bytes);
    }

    public void write(File file, byte[] bytes, boolean append) throws IOException {
        this.liferayFile.write(file, bytes, append);
    }

    public void write(File file, byte[] bytes, int offset, int length) throws IOException {
        this.liferayFile.write(file, bytes, offset, length);
    }

    public void write(File file, byte[] bytes, int offset, int length, boolean append) throws IOException {
        this.liferayFile.write(file, bytes, offset, length, append);
    }

    public void write(File file, InputStream is) throws IOException {
        this.liferayFile.write(file, is);
    }

    public void write(File file, String s) throws IOException {
        this.liferayFile.write(file, s);
    }

    public void write(File file, String s, boolean lazy) throws IOException {
        this.liferayFile.write(file, s, lazy);
    }

    public void write(File file, String s, boolean lazy, boolean append) throws IOException {
        this.liferayFile.write(file, s, lazy, append);
    }

    public void write(String fileName, byte[] bytes) throws IOException {
        this.liferayFile.write(fileName, bytes);
    }

    public void write(String fileName, InputStream is) throws IOException {
        this.liferayFile.write(fileName, is);
    }

    public void write(String fileName, String s) throws IOException {
        this.liferayFile.write(fileName, s);
    }

    public void write(String fileName, String s, boolean lazy) throws IOException {
        this.liferayFile.write(fileName, s, lazy);
    }

    public void write(String fileName, String s, boolean lazy, boolean append) throws IOException {
        this.liferayFile.write(fileName, s, lazy, append);
    }

    public void write(String pathName, String fileName, String s) throws IOException {
        this.liferayFile.write(pathName, fileName, s);
    }

    public void write(String pathName, String fileName, String s, boolean lazy) throws IOException {
        this.liferayFile.write(pathName, fileName, s, lazy);
    }

    public void write(String pathName, String fileName, String s, boolean lazy, boolean append) throws IOException {
        this.liferayFile.write(pathName, fileName, s, lazy, append);
    }
}

