/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.liferay.client.impl.liferay71;

import com.liferay.document.library.kernel.document.conversion.DocumentConversion;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.SystemProperties;
import de.mklinger.micro.annotations.VisibleForTesting;
import de.mklinger.qetcher.client.QetcherClientException;
import de.mklinger.qetcher.client.model.v1.MediaType;
import de.mklinger.qetcher.liferay.client.QetcherConversionsService;
import de.mklinger.qetcher.liferay.client.QetcherService;
import de.mklinger.qetcher.liferay.client.impl.QetcherConfiguration;
import de.mklinger.qetcher.liferay.client.impl.liferay71.MultiLock;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, property={"qetcher:Boolean=true", "service.ranking:Integer=1000"}, configurationPid={"de.mklinger.qetcher.liferay.client.impl.QetcherConfiguration"}, configurationPolicy=ConfigurationPolicy.REQUIRE)
public class QetcherDocumentConversionImpl
implements DocumentConversion {
    private static final String APPLICATION_OCTETSTREAM = "application/octet-stream";
    private static final Logger LOG = LoggerFactory.getLogger(QetcherDocumentConversionImpl.class);
    private final String[] comparableFileExtensions;
    private final String tmpDir;
    private final MultiLock conversionLock;
    private QetcherService qetcherService;
    private QetcherConversionsService qetcherConversionsService;
    private QetcherConfiguration configuration;

    public QetcherDocumentConversionImpl() {
        this(PropsUtil.getArray((String)"dl.comparable.file.extensions"), SystemProperties.get((String)"java.io.tmpdir"));
    }

    @VisibleForTesting
    protected QetcherDocumentConversionImpl(String[] comparableFileExtensions, String tmpDir) {
        this.comparableFileExtensions = comparableFileExtensions;
        this.tmpDir = tmpDir;
        this.conversionLock = new MultiLock();
    }

    @Reference
    public void setQetcherService(QetcherService qetcherService) {
        this.qetcherService = qetcherService;
    }

    @Reference
    public void setQetcherConversionsService(QetcherConversionsService qetcherConversionsService) {
        this.qetcherConversionsService = qetcherConversionsService;
    }

    @Activate
    @Modified
    public synchronized void activate(Map<String, Object> configurationProperties) {
        LOG.debug("Configuration was set");
        this.setConfiguration((QetcherConfiguration)ConfigurableUtil.createConfigurable(QetcherConfiguration.class, configurationProperties));
    }

    @VisibleForTesting
    protected void setConfiguration(QetcherConfiguration configuration) {
        this.configuration = configuration;
    }

    public File convert(String id, InputStream inputStream, String sourceExtension, String targetExtension) throws IOException {
        Path targetFile = Paths.get(this.getFilePath(id, targetExtension), new String[0]);
        Throwable throwable = null;
        try (MultiLock.Lock lock = this.conversionLock.lock(id);){
            if (this.configuration.documentConversionCacheEnabled() && Files.exists(targetFile, new LinkOption[0])) {
                LOG.debug("Document conversion cache hit for id {}", (Object)id);
                File file = targetFile.toFile();
                return file;
            }
            LOG.debug("Document conversion cache miss for id {}", (Object)id);
            try {
                File file = this.doConvert(id, inputStream, sourceExtension, targetExtension, targetFile);
                return file;
            }
            catch (Exception e) {
                try {
                    FileUtil.delete((File)targetFile.toFile());
                    throw e;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
    }

    private File doConvert(String id, InputStream inputStream, String sourceExtension, String targetExtension, Path targetFile) throws IOException {
        MediaType fromMediaType = this.getMediaTypeForExtension(sourceExtension);
        MediaType toMediaType = this.getMediaTypeForExtension(targetExtension);
        String referrer = "liferay-conversion-id=" + id;
        Path targetDir = targetFile.getParent();
        Files.createDirectories(targetDir, new FileAttribute[0]);
        LOG.info("Starting conversion with referrer '{}': {} -> {}", new Object[]{referrer, fromMediaType, toMediaType});
        this.qetcherService.convertToFile(inputStream, targetFile, fromMediaType, toMediaType, referrer);
        return targetFile.toFile();
    }

    public MediaType getMediaTypeForExtension(String extension) {
        String mediaTypeString = MimeTypesUtil.getExtensionContentType((String)extension);
        if (mediaTypeString == null || APPLICATION_OCTETSTREAM.equals(mediaTypeString)) {
            throw new QetcherClientException("Unable to map extension to media type: " + extension);
        }
        return MediaType.valueOf((String)mediaTypeString);
    }

    public String[] getConversions(String extension) {
        return this.qetcherConversionsService.getTargetExtensionsForExtension(extension);
    }

    public String getFilePath(String id, String targetExtension) {
        StringBundler sb = new StringBundler(5);
        sb.append(this.tmpDir);
        sb.append("/liferay/document_conversion/");
        sb.append(id);
        sb.append(".");
        sb.append(targetExtension);
        return sb.toString();
    }

    public boolean isComparableVersion(String extension) {
        boolean enabled = false;
        String periodAndExtension = ".".concat(extension);
        for (String comparableFileExtension : this.comparableFileExtensions) {
            if (!"*".equals(comparableFileExtension) && !periodAndExtension.equals(comparableFileExtension)) continue;
            enabled = true;
            break;
        }
        if (!enabled) {
            return false;
        }
        if (extension.equals("css") || extension.equals("htm") || extension.equals("html") || extension.equals("js") || extension.equals("txt") || extension.equals("xml")) {
            return true;
        }
        try {
            if (this.isEnabled() && this.isConvertBeforeCompare(extension)) {
                return true;
            }
        }
        catch (Exception e) {
            LOG.error("Error in {}.isComparableVersion('{}')", new Object[]{this.getClass().getSimpleName(), extension, e});
        }
        return false;
    }

    public boolean isConvertBeforeCompare(String extension) {
        if (extension.equals("txt")) {
            return false;
        }
        for (String conversion : this.getConversions(extension)) {
            if (!conversion.equals("txt")) continue;
            return true;
        }
        return false;
    }

    public boolean isEnabled() {
        return true;
    }

    public void disconnect() {
    }
}

