/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.liferay.client.impl.liferay71;

import com.liferay.document.library.kernel.util.AudioProcessor;
import com.liferay.document.library.kernel.util.DLPreviewableProcessor;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.xml.Element;
import java.io.InputStream;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class QetcherAudioProcessorImplBoilerplate
extends DLPreviewableProcessor
implements AudioProcessor {
    protected static final String[] _PREVIEW_TYPES = PropsUtil.getArray((String)"dl.file.entry.preview.audio.containers");
    private static final Logger LOG = LoggerFactory.getLogger(QetcherAudioProcessorImplBoilerplate.class);
    protected final Set<String> liferayAudioMimeTypes = SetUtil.fromArray((Object[])PropsUtil.getArray((String)"dl.file.entry.preview.audio.mime.types"));
    protected final List<Long> _fileVersionIds = new Vector<Long>();

    public void afterPropertiesSet() throws Exception {
        FileUtil.mkdirs((String)PREVIEW_TMP_PATH);
    }

    public InputStream getPreviewAsStream(FileVersion fileVersion, String type) throws Exception {
        return this.doGetPreviewAsStream(fileVersion, type);
    }

    public long getPreviewFileSize(FileVersion fileVersion, String type) throws Exception {
        return this.doGetPreviewFileSize(fileVersion, type);
    }

    public String getType() {
        return "AudioProcessor";
    }

    public boolean hasAudio(FileVersion fileVersion) {
        boolean hasAudio = false;
        try {
            hasAudio = this._hasAudio(fileVersion);
            if (!hasAudio && this.isSupported(fileVersion)) {
                this._queueGeneration(null, fileVersion);
            }
        }
        catch (Exception e) {
            LOG.error("Error in hasAudio()", (Throwable)e);
        }
        return hasAudio;
    }

    public boolean isAudioSupported(FileVersion fileVersion) {
        return this.isSupported(fileVersion);
    }

    public boolean isAudioSupported(String mimeType) {
        return this.isSupported(mimeType);
    }

    public void trigger(FileVersion sourceFileVersion, FileVersion destinationFileVersion) {
        super.trigger(sourceFileVersion, destinationFileVersion);
        this._queueGeneration(sourceFileVersion, destinationFileVersion);
    }

    protected void doExportGeneratedFiles(PortletDataContext portletDataContext, FileEntry fileEntry, Element fileEntryElement) throws Exception {
        this.exportPreviews(portletDataContext, fileEntry, fileEntryElement);
    }

    protected void doImportGeneratedFiles(PortletDataContext portletDataContext, FileEntry fileEntry, FileEntry importedFileEntry, Element fileEntryElement) throws Exception {
        this.importPreviews(portletDataContext, fileEntry, importedFileEntry, fileEntryElement);
    }

    protected void exportPreviews(PortletDataContext portletDataContext, FileEntry fileEntry, Element fileEntryElement) throws Exception {
        FileVersion fileVersion = fileEntry.getFileVersion();
        if (!this.isSupported(fileVersion) || !this.hasPreviews(fileVersion)) {
            return;
        }
        if (!portletDataContext.isPerformDirectBinaryImport()) {
            for (String previewType : _PREVIEW_TYPES) {
                this.exportPreview(portletDataContext, fileEntry, fileEntryElement, "audio", previewType);
            }
        }
    }

    protected List<Long> getFileVersionIds() {
        return this._fileVersionIds;
    }

    protected String getPreviewType(FileVersion fileVersion) {
        return _PREVIEW_TYPES[0];
    }

    protected String[] getPreviewTypes() {
        return _PREVIEW_TYPES;
    }

    protected String getThumbnailType(FileVersion fileVersion) {
        return null;
    }

    protected void importPreviews(PortletDataContext portletDataContext, FileEntry fileEntry, FileEntry importedFileEntry, Element fileEntryElement) throws Exception {
        if (_PREVIEW_TYPES.length == 0 || _PREVIEW_TYPES.length > 2) {
            return;
        }
        for (String previewType : _PREVIEW_TYPES) {
            if (!previewType.equals("mp3") && !previewType.equals("ogg")) continue;
            this.importPreview(portletDataContext, fileEntry, importedFileEntry, fileEntryElement, "audio", previewType);
        }
    }

    protected boolean _hasAudio(FileVersion fileVersion) throws Exception {
        if (!this.isSupported(fileVersion)) {
            return false;
        }
        return this.hasPreviews(fileVersion);
    }

    private void _queueGeneration(FileVersion sourceFileVersion, FileVersion destinationFileVersion) {
        if (this._fileVersionIds.contains(destinationFileVersion.getFileVersionId()) || !this.isSupported(destinationFileVersion)) {
            return;
        }
        this._fileVersionIds.add(destinationFileVersion.getFileVersionId());
        this.sendGenerationMessage("liferay/document_library_audio_processor", sourceFileVersion, destinationFileVersion);
    }
}

