/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.liferay.client.impl.liferay71;

import com.liferay.document.library.kernel.exception.NoSuchFileEntryException;
import com.liferay.document.library.kernel.util.AudioProcessor;
import com.liferay.document.library.kernel.util.DLUtil;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.util.FileUtil;
import de.mklinger.qetcher.client.model.v1.MediaType;
import de.mklinger.qetcher.liferay.client.QetcherConversionsService;
import de.mklinger.qetcher.liferay.client.QetcherService;
import de.mklinger.qetcher.liferay.client.impl.QetcherConfiguration;
import de.mklinger.qetcher.liferay.client.impl.liferay71.ProcessorMediaTypes;
import de.mklinger.qetcher.liferay.client.impl.liferay71.QetcherAudioProcessorImplBoilerplate;
import java.io.File;
import java.io.InputStream;
import java.util.Map;
import java.util.Set;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, property={"qetcher:Boolean=true", "service.ranking:Integer=1000"}, configurationPid={"de.mklinger.qetcher.liferay.client.impl.QetcherConfiguration"}, configurationPolicy=ConfigurationPolicy.REQUIRE)
public class QetcherAudioProcessorImpl
extends QetcherAudioProcessorImplBoilerplate
implements AudioProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(QetcherAudioProcessorImpl.class);
    private QetcherService qetcherService;
    private QetcherConversionsService qetcherConversionsService;
    private ProcessorMediaTypes processorMediaTypes;
    private QetcherConfiguration qetcherConfiguration;

    @Reference
    public void setQetcherService(QetcherService qetcherService) {
        this.qetcherService = qetcherService;
    }

    @Reference
    public void setQetcherConversionsService(QetcherConversionsService qetcherConversionsService) {
        this.qetcherConversionsService = qetcherConversionsService;
    }

    @Reference
    public void setProcessorMediaTypes(ProcessorMediaTypes processorMediaTypes) {
        this.processorMediaTypes = processorMediaTypes;
    }

    @Activate
    @Modified
    public synchronized void activate(Map<String, Object> configurationProperties) throws Exception {
        LOG.debug("Configuration was set");
        this.setQetcherConfiguration((QetcherConfiguration)ConfigurableUtil.createConfigurable(QetcherConfiguration.class, configurationProperties));
        super.afterPropertiesSet();
    }

    private void setQetcherConfiguration(QetcherConfiguration qetcherConfiguration) {
        this.qetcherConfiguration = qetcherConfiguration;
    }

    public boolean isSupported(String mimeType) {
        if (this.getAudioMimeTypes().contains(mimeType)) {
            LOG.debug("Supported audio type: {}", (Object)mimeType);
            return true;
        }
        LOG.debug("Unsupported audio type: {}", (Object)mimeType);
        return false;
    }

    public Set<String> getAudioMimeTypes() {
        if (this.qetcherConfiguration.useAllSupportedAudioTypes()) {
            return this.qetcherConversionsService.getSourceMediaTypesForRegistry("audio");
        }
        return this.liferayAudioMimeTypes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateAudio(FileVersion sourceFileVersion, FileVersion destinationFileVersion) throws Exception {
        block26: {
            try {
                if (sourceFileVersion != null) {
                    this.copy(sourceFileVersion, destinationFileVersion);
                    return;
                }
                if (this._hasAudio(destinationFileVersion)) {
                    return;
                }
                if (this.hasPreviews(destinationFileVersion)) break block26;
                for (String previewType : _PREVIEW_TYPES) {
                    try (InputStream inputStream = destinationFileVersion.getContentStream(false);){
                        this.generateAudioQetcher(destinationFileVersion, inputStream, previewType);
                    }
                    catch (NoSuchFileEntryException nsfee) {
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug("File entry not found", (Throwable)nsfee);
                    }
                    catch (Exception e) {
                        LOG.error("Error generating audio for file version " + destinationFileVersion.getFileVersionId(), (Throwable)e);
                    }
                }
            }
            catch (NoSuchFileEntryException nsfee) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("File entry not found", (Throwable)nsfee);
                }
            }
            finally {
                this._fileVersionIds.remove(destinationFileVersion.getFileVersionId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateAudioQetcher(FileVersion fileVersion, InputStream inputStream, String containerType) throws Exception {
        if (this.hasPreview(fileVersion, containerType)) {
            return;
        }
        String tempFileId = DLUtil.getTempFileId((long)fileVersion.getFileEntryId(), (String)fileVersion.getVersion());
        File previewTempFile = this.getPreviewTempFile(tempFileId, containerType);
        try {
            MediaType fromMediaType = this.processorMediaTypes.getMediaType(fileVersion);
            MediaType toMediaType = this.processorMediaTypes.getContainerMediaType(containerType);
            String referrer = "liferay-audioprocessor-id=" + tempFileId;
            LOG.info("Converting file version {} from {} to {}", new Object[]{fileVersion.getFileVersionId(), fromMediaType, toMediaType});
            this.qetcherService.convertToFile(inputStream, previewTempFile.toPath(), fromMediaType, toMediaType, referrer);
            this.addFileToStore(fileVersion.getCompanyId(), "document_preview/", this.getPreviewFilePath(fileVersion, containerType), previewTempFile);
        }
        finally {
            FileUtil.delete((File)previewTempFile);
        }
    }
}

