/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.liferay.client.impl;

import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.util.Supplier;
import de.mklinger.micro.annotations.VisibleForTesting;
import de.mklinger.micro.keystores.KeyStores;
import de.mklinger.qetcher.liferay.client.impl.QetcherTrustStoreConfiguration;
import java.security.KeyStore;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(configurationPid={"de.mklinger.qetcher.liferay.client.impl.QetcherTrustStoreConfiguration"}, service={QetcherTrustStoreSupplier.class})
public class QetcherTrustStoreSupplier
implements Supplier<KeyStore> {
    private static final Logger LOG = LoggerFactory.getLogger(QetcherTrustStoreSupplier.class);
    private KeyStore trustStore;

    @Activate
    @Modified
    public void activate(Map<String, Object> properties) {
        LOG.debug("Trust store supplier activated");
        QetcherTrustStoreConfiguration configuration = (QetcherTrustStoreConfiguration)ConfigurableUtil.createConfigurable(QetcherTrustStoreConfiguration.class, properties);
        this.activate(configuration);
    }

    @VisibleForTesting
    protected synchronized void activate(QetcherTrustStoreConfiguration configuration) {
        this.trustStore = this.loadTrustStore(configuration);
    }

    @Deactivate
    protected synchronized void deactivate() {
        this.trustStore = null;
    }

    @VisibleForTesting
    protected KeyStore loadTrustStore(QetcherTrustStoreConfiguration configuration) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Loading Qetcher trust store from {}", (Object)configuration.trustStoreLocation());
        }
        if ("pem".equalsIgnoreCase(configuration.trustStoreType())) {
            return KeyStores.loadPemCertificates((String)configuration.trustStoreLocation(), (ClassLoader)this.getClass().getClassLoader());
        }
        String actualType = configuration.trustStoreType() == null || configuration.trustStoreType().isEmpty() ? KeyStore.getDefaultType() : configuration.trustStoreType();
        return KeyStores.load((String)configuration.trustStoreLocation(), (String)configuration.trustStorePassword(), (String)actualType, (ClassLoader)this.getClass().getClassLoader());
    }

    public KeyStore get() {
        return this.trustStore;
    }
}

