/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.liferay.client.impl;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.TimeUnit;
import org.osgi.service.component.annotations.Component;

@Component(service={QetcherTimeoutConfig.class})
public class QetcherTimeoutConfig {
    private final TimeValue shortTimeout = TimeValue.seconds(30L);
    private final TimeValue uploadTimeout = TimeValue.hours(1L);
    private final TimeValue downloadTimeout = TimeValue.hours(1L);
    private final TimeValue jobCreateTimeout = TimeValue.seconds(30L);
    private final TimeValue jobWaitTimeout = TimeValue.hours(1L);
    private final TimeValue jobDeleteTimeout = TimeValue.seconds(30L);
    private final TimeValue jobServiceCancelTimeout = this.jobWaitTimeout.plus(TimeValue.minutes(1L));
    private final TimeValue jobServiceDeleteTimeout;
    private final TimeValue fileServiceDeleteTimeout = this.jobServiceDeleteTimeout = this.jobServiceCancelTimeout.plus(TimeValue.minutes(30L));

    public TimeValue getShortTimeout() {
        return this.shortTimeout;
    }

    public TimeValue getUploadTimeout() {
        return this.uploadTimeout;
    }

    public TimeValue getDownloadTimeout() {
        return this.downloadTimeout;
    }

    public TimeValue getJobCreateTimeout() {
        return this.jobCreateTimeout;
    }

    public TimeValue getJobWaitTimeout() {
        return this.jobWaitTimeout;
    }

    public TimeValue getJobDeleteTimeout() {
        return this.jobDeleteTimeout;
    }

    public TimeValue getJobServiceCancelTimeout() {
        return this.jobServiceCancelTimeout;
    }

    public TimeValue getJobServiceDeleteTimeout() {
        return this.jobServiceDeleteTimeout;
    }

    public TimeValue getFileServiceDeleteTimeout() {
        return this.fileServiceDeleteTimeout;
    }

    public static class TimeValue {
        private final long time;
        private final TimeUnit timeUnit;

        public TimeValue(long time, TimeUnit timeUnit) {
            this.time = time;
            this.timeUnit = timeUnit;
        }

        public static TimeValue seconds(long seconds) {
            return new TimeValue(seconds, TimeUnit.SECONDS);
        }

        public static TimeValue minutes(long minutes) {
            return new TimeValue(minutes, TimeUnit.MINUTES);
        }

        public static TimeValue hours(long hours) {
            return new TimeValue(hours, TimeUnit.HOURS);
        }

        public TimeValue plus(TimeValue timeValue) {
            return TimeValue.of(this.toDuration().plus(timeValue.toDuration()));
        }

        public static TimeValue of(Duration duration) {
            if (duration.getSeconds() > 0L) {
                try {
                    return new TimeValue(duration.toMillis(), TimeUnit.MILLISECONDS);
                }
                catch (ArithmeticException e) {
                    return new TimeValue(duration.getSeconds(), TimeUnit.SECONDS);
                }
            }
            return new TimeValue(duration.getNano(), TimeUnit.NANOSECONDS);
        }

        public long time() {
            return this.time;
        }

        public TimeUnit unit() {
            return this.timeUnit;
        }

        public Duration toDuration() {
            switch (this.timeUnit) {
                case NANOSECONDS: {
                    return Duration.of(this.time, ChronoUnit.NANOS);
                }
                case MICROSECONDS: {
                    return Duration.of(this.time, ChronoUnit.MICROS);
                }
                case SECONDS: {
                    return Duration.of(this.time, ChronoUnit.SECONDS);
                }
                case MINUTES: {
                    return Duration.of(this.time, ChronoUnit.MINUTES);
                }
                case HOURS: {
                    return Duration.of(this.time, ChronoUnit.HOURS);
                }
                case DAYS: {
                    return Duration.of(this.time, ChronoUnit.DAYS);
                }
            }
            return Duration.of(this.timeUnit.toMillis(this.time), ChronoUnit.MILLIS);
        }
    }
}

