/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.liferay.client.impl;

import de.mklinger.qetcher.client.InputConversionFile;
import de.mklinger.qetcher.client.InputJob;
import de.mklinger.qetcher.client.QetcherClient;
import de.mklinger.qetcher.client.model.v1.AvailableConversion;
import de.mklinger.qetcher.client.model.v1.Job;
import de.mklinger.qetcher.client.model.v1.MediaType;
import de.mklinger.qetcher.client.model.v1.MediaTypes;
import de.mklinger.qetcher.htmlinliner.HtmlElementInliner;
import de.mklinger.qetcher.liferay.client.QetcherClientService;
import de.mklinger.qetcher.liferay.client.QetcherService;
import de.mklinger.qetcher.liferay.client.impl.LiferayHtmlElementInlinerFactory;
import de.mklinger.qetcher.liferay.client.impl.QetcherJobs;
import de.mklinger.qetcher.liferay.client.impl.QetcherTimeoutConfig;
import de.mklinger.qetcher.liferay.client.impl.abstraction.liferay71.LiferayAbstractionFactorySupplier;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class QetcherServiceImpl
implements QetcherService {
    private static final Logger LOG = LoggerFactory.getLogger(QetcherServiceImpl.class);
    private QetcherClientService clientService;
    private QetcherJobs qetcherJobs;
    private QetcherTimeoutConfig timeoutConfig;

    @Reference
    public void setClientService(QetcherClientService clientService) {
        this.clientService = clientService;
    }

    @Reference
    public void setQetcherJobs(QetcherJobs qetcherJobs) {
        this.qetcherJobs = qetcherJobs;
    }

    @Reference
    public void setTimeoutConfig(QetcherTimeoutConfig timeoutConfig) {
        this.timeoutConfig = timeoutConfig;
    }

    @Override
    public Path convertToFile(InputStream inputStream, Path targetFile, MediaType fromMediaType, MediaType toMediaType, String referrer) {
        try {
            return (Path)this.doConvert(inputStream, fromMediaType, toMediaType, referrer, fileId -> this.clientService.client().downloadAsFile(fileId, targetFile));
        }
        catch (CompletionException e) {
            throw QetcherServiceImpl.unwrap(e);
        }
    }

    @Override
    public List<Path> convertToFiles(InputStream inputStream, Function<Integer, Path> targetFileSupplier, MediaType fromMediaType, MediaType toMediaType, String referrer) {
        try {
            return (List)this.doConvert(inputStream, fromMediaType, toMediaType, referrer, Job::getResultFileIds, resultFileIds -> this.downloadAll((List<String>)resultFileIds, targetFileSupplier));
        }
        catch (CompletionException e) {
            throw QetcherServiceImpl.unwrap(e);
        }
    }

    @Override
    public Path convertToTempFile(InputStream inputStream, MediaType fromMediaType, MediaType toMediaType, String referrer) {
        try {
            return (Path)this.doConvert(inputStream, fromMediaType, toMediaType, referrer, arg_0 -> ((QetcherClient)this.clientService.client()).downloadAsTempFile(arg_0));
        }
        catch (CompletionException e) {
            throw QetcherServiceImpl.unwrap(e);
        }
    }

    @Override
    public byte[] convertToByteArray(InputStream inputStream, MediaType fromMediaType, MediaType toMediaType, String referrer) {
        try {
            return (byte[])this.doConvert(inputStream, fromMediaType, toMediaType, referrer, arg_0 -> ((QetcherClient)this.clientService.client()).downloadAsByteArray(arg_0));
        }
        catch (CompletionException e) {
            throw QetcherServiceImpl.unwrap(e);
        }
    }

    private <T> T doConvert(InputStream inputStream, MediaType fromMediaType, MediaType toMediaType, String referrer, Function<String, ? extends CompletionStage<T>> jobSuccessAction) {
        return this.doConvert(inputStream, fromMediaType, toMediaType, referrer, this.qetcherJobs::getSingleResultFileId, jobSuccessAction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T, X> T doConvert(InputStream inputStream, MediaType fromMediaType, MediaType toMediaType, String referrer, Function<Job, X> jobMapping, Function<X, ? extends CompletionStage<T>> jobSuccessAction) {
        InputStream actualInputStream = this.getActualInputStream(inputStream, fromMediaType);
        InputJob inputJob = this.newInputJob(actualInputStream, fromMediaType, toMediaType, referrer);
        Job job = this.qetcherJobs.createJobWithTimeout(inputJob).join();
        try {
            Object t = ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.qetcherJobs.getJobDoneWithTimeout(job).thenApply(this.qetcherJobs::requireSuccess)).thenApply(jobMapping)).thenCompose(jobSuccessAction)).join();
            return t;
        }
        finally {
            this.qetcherJobs.deleteJobWithTimeout(job).exceptionally(e -> {
                LOG.warn("Error deleting job", e);
                return null;
            });
        }
    }

    private InputJob newInputJob(InputStream actualInputStream, MediaType from, MediaType to, String referrer) {
        InputConversionFile inputFile = this.clientService.inputFileFor(actualInputStream).mediaType(from).build();
        InputJob inputJob = this.clientService.job().fromFile(inputFile).toMediaType(to).referrer(referrer).cancelTimeout(this.timeoutConfig.getJobServiceCancelTimeout().toDuration()).deleteTimeout(this.timeoutConfig.getJobServiceDeleteTimeout().toDuration()).build();
        return inputJob;
    }

    private InputStream getActualInputStream(InputStream inputStream, MediaType from) {
        if (MediaTypes.HTML.isCompatible(from)) {
            return this.inlineHtmlElements(inputStream);
        }
        return inputStream;
    }

    private InputStream inlineHtmlElements(InputStream inputStream) {
        byte[] data;
        LOG.info("Inlining HTML elements...");
        String baseUri = LiferayAbstractionFactorySupplier.getInstance().getPortalTool().getBaseUrl();
        if (baseUri == null) {
            LOG.warn("Could not get base URL - no HTML inlining can be done");
            return inputStream;
        }
        try (InputStream in = inputStream;
             HtmlElementInliner inliner = LiferayHtmlElementInlinerFactory.newHtmlElementInliner();){
            data = inliner.inline(in, baseUri);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return new ByteArrayInputStream(data);
    }

    private CompletableFuture<List<Path>> downloadAll(List<String> resultFileIds, Function<Integer, Path> targetFileSupplier) {
        ArrayList resultFiles = new ArrayList(resultFileIds.size());
        int idx = 0;
        for (String fileId : resultFileIds) {
            Path targetFile = targetFileSupplier.apply(idx);
            this.clientService.client().downloadAsFile(fileId, targetFile).join();
            ++idx;
        }
        return CompletableFuture.completedFuture(resultFiles);
    }

    private static RuntimeException unwrap(CompletionException e) {
        Throwable cause = e.getCause();
        if (cause != null && cause instanceof RuntimeException) {
            return (RuntimeException)cause;
        }
        return e;
    }

    @Override
    public List<AvailableConversion> getAvailableConversions() {
        return (List)this.clientService.client().getAvailableConversions().join();
    }
}

