/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.liferay.client.impl;

import de.mklinger.qetcher.client.InputJob;
import de.mklinger.qetcher.client.QetcherClientException;
import de.mklinger.qetcher.client.QetcherRemoteException;
import de.mklinger.qetcher.client.common.concurrent.Delay;
import de.mklinger.qetcher.client.model.v1.Job;
import de.mklinger.qetcher.client.model.v1.JobState;
import de.mklinger.qetcher.liferay.client.QetcherClientService;
import de.mklinger.qetcher.liferay.client.impl.QetcherTimeoutConfig;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={QetcherJobs.class})
public class QetcherJobs {
    private static final Logger LOG = LoggerFactory.getLogger(QetcherJobs.class);
    private QetcherClientService clientService;
    private QetcherTimeoutConfig timeoutConfig;

    @Reference
    public void setClientService(QetcherClientService clientService) {
        this.clientService = clientService;
    }

    @Reference
    public void setTimeoutConfig(QetcherTimeoutConfig timeoutConfig) {
        this.timeoutConfig = timeoutConfig;
    }

    public CompletableFuture<Job> createJobWithTimeout(InputJob inputJob) {
        QetcherTimeoutConfig.TimeValue timeout = this.timeoutConfig.getJobCreateTimeout();
        return Delay.timeout((CompletableFuture)this.clientService.client().createJob(inputJob), (long)timeout.time(), (TimeUnit)timeout.unit(), () -> new TimeoutException("Timeout creating job: " + inputJob.getFromMediaType() + " -> " + inputJob.getToMediaType()));
    }

    public CompletableFuture<Job> getJobDoneWithTimeout(Job job) {
        QetcherTimeoutConfig.TimeValue timeout = this.timeoutConfig.getJobWaitTimeout();
        return Delay.timeout((CompletableFuture)this.clientService.client().getJobDone(job), (long)timeout.time(), (TimeUnit)timeout.unit(), () -> new TimeoutException("Timeout getting job done " + job.getJobId() + " " + job.getFromMediaType() + " -> " + job.getToMediaType()));
    }

    public Job requireSuccess(Job job) {
        if (job.getState() != JobState.SUCCESS) {
            QetcherRemoteException cause = job.getError() != null ? new QetcherRemoteException(job.getError(), -1) : null;
            throw new QetcherClientException("Job " + job.getJobId() + " is not in state SUCCESS but " + job.getState(), (Throwable)cause);
        }
        return job;
    }

    public CompletableFuture<Void> deleteJobWithTimeout(Job job) {
        QetcherTimeoutConfig.TimeValue timeout = this.timeoutConfig.getJobDeleteTimeout();
        return Delay.timeout((CompletableFuture)this.clientService.client().deleteJob(job), (long)timeout.time(), (TimeUnit)timeout.unit(), () -> new TimeoutException("Timeout deleting job " + job.getJobId() + " " + job.getFromMediaType() + " -> " + job.getToMediaType()));
    }

    public String getSingleResultFileId(Job job) {
        List resultFileIds = job.getResultFileIds();
        if (resultFileIds == null || resultFileIds.isEmpty()) {
            throw new QetcherClientException("Expected 1 result file but have no result files");
        }
        if (resultFileIds.size() != 1) {
            LOG.warn("Expected 1 result file but is " + resultFileIds.size());
        }
        return (String)resultFileIds.get(0);
    }
}

