/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.liferay.client.impl;

import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import de.mklinger.qetcher.client.model.v1.AvailableConversion;
import de.mklinger.qetcher.client.model.v1.Conversion;
import de.mklinger.qetcher.client.model.v1.MediaType;
import de.mklinger.qetcher.liferay.client.QetcherClientService;
import de.mklinger.qetcher.liferay.client.QetcherConversionsService;
import de.mklinger.qetcher.liferay.client.impl.QetcherConfiguration;
import de.mklinger.qetcher.liferay.client.impl.QetcherConversionsCache;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(configurationPid={"de.mklinger.qetcher.liferay.client.impl.QetcherConfiguration"}, configurationPolicy=ConfigurationPolicy.REQUIRE)
public class QetcherConversionsServiceImpl
implements QetcherConversionsService {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final Logger LOG = LoggerFactory.getLogger(QetcherConversionsServiceImpl.class);
    private QetcherClientService clientService;
    private QetcherConversionsCache conversionsCache;
    private QetcherConfiguration configuration;

    @Reference
    public void setClientService(QetcherClientService clientService) {
        this.clientService = clientService;
    }

    @Reference
    public void setConversionsCache(QetcherConversionsCache conversionsCache) {
        this.conversionsCache = conversionsCache;
    }

    @Activate
    @Modified
    public synchronized void activate(Map<String, Object> configurationProperties) {
        LOG.debug("Configuration was set");
        this.configuration = (QetcherConfiguration)ConfigurableUtil.createConfigurable(QetcherConfiguration.class, configurationProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getTargetExtensionsForExtension(String extension) {
        if (extension == null || extension.isEmpty()) {
            return EMPTY_STRING_ARRAY;
        }
        String[] result = this.conversionsCache.getTargetExtensionsFromCache(extension);
        if (result == null) {
            QetcherConversionsServiceImpl qetcherConversionsServiceImpl = this;
            synchronized (qetcherConversionsServiceImpl) {
                result = this.conversionsCache.getTargetExtensionsFromCache(extension);
                if (result == null) {
                    result = this.loadTargetExtensions(extension);
                    this.conversionsCache.putTargetExtensionsToCache(extension, result);
                }
            }
        }
        return result;
    }

    private String[] loadTargetExtensions(String extension) {
        Object[] newResult;
        Map<String, Set<String>> supportedConversionsExtensions = this.getSupportedConversionsExtensions();
        Set<String> targetExtensions = supportedConversionsExtensions.get(extension);
        if (targetExtensions == null || targetExtensions.isEmpty()) {
            LOG.debug("Found no conversions for source extension {}", (Object)extension);
            newResult = EMPTY_STRING_ARRAY;
        } else {
            LOG.debug("Found {} conversions for source extension {}", (Object)targetExtensions.size(), (Object)extension);
            Set<String> extensionWhitelist = this.getExtensionWhitelist(extension);
            if (extensionWhitelist != null && !extensionWhitelist.isEmpty() || targetExtensions.contains(extension)) {
                targetExtensions = new HashSet<String>(targetExtensions);
                targetExtensions.remove(extension);
                if (extensionWhitelist != null) {
                    targetExtensions.retainAll(extensionWhitelist);
                }
            }
            newResult = targetExtensions.isEmpty() ? EMPTY_STRING_ARRAY : targetExtensions.toArray(new String[targetExtensions.size()]);
        }
        Arrays.sort(newResult);
        return newResult;
    }

    protected Set<String> getExtensionWhitelist(String extension) {
        Set<String> extensionWhitelist = this.configuration.conversionExtensionsSinglepage().contains(extension) ? this.configuration.conversionExtensionsWhitelistSinglepage() : this.configuration.conversionExtensionsWhitelistMultipage();
        return extensionWhitelist;
    }

    private Map<String, Set<String>> getSupportedConversionsExtensions() {
        HashMap<String, Set<String>> supportedConversionsExtensions = new HashMap<String, Set<String>>();
        List<AvailableConversion> availableConversions = this.getAvailableConversions();
        for (AvailableConversion availableConversion : availableConversions) {
            Conversion conversion = availableConversion.getConversion();
            MediaType from = conversion.getFrom();
            Set<String> fromExtensions = this.getExtensionsWithoutLeadingDot(from);
            if (fromExtensions == null) continue;
            for (String fromExtension : fromExtensions) {
                this.addExtensions(supportedConversionsExtensions, fromExtension, conversion.getTo());
            }
        }
        return supportedConversionsExtensions;
    }

    private void addExtensions(Map<String, Set<String>> supportedConversionsExtensions, String fromExtension, MediaType to) {
        Set toExtensions = supportedConversionsExtensions.computeIfAbsent(fromExtension, unused -> new HashSet());
        Set<String> newToExtensions = this.getExtensionsWithoutLeadingDot(to);
        if (newToExtensions != null) {
            toExtensions.addAll(newToExtensions);
        }
    }

    private Set<String> getExtensionsWithoutLeadingDot(MediaType mediaType) {
        Set<String> extensions = this.getExtensionsForMediaType(mediaType);
        if (extensions == null || extensions.isEmpty()) {
            return extensions;
        }
        LinkedHashSet<String> extensionsWithoutLeadingDot = new LinkedHashSet<String>(extensions.size());
        for (String extension : extensions) {
            if (extension == null) continue;
            extensionsWithoutLeadingDot.add(this.getExtensionWithoutLeadingDot(extension));
        }
        return extensionsWithoutLeadingDot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getExtensionsForMediaType(MediaType from) {
        Set<String> extensions = this.conversionsCache.getExtensionsForMediaTypeFromCache(from);
        if (extensions == null) {
            QetcherConversionsServiceImpl qetcherConversionsServiceImpl = this;
            synchronized (qetcherConversionsServiceImpl) {
                extensions = this.conversionsCache.getExtensionsForMediaTypeFromCache(from);
                if (extensions == null) {
                    extensions = this.loadExtensionsForMediaType(from);
                    this.conversionsCache.putExtensionsForMediaTypeToCache(from, extensions);
                }
            }
        }
        return extensions;
    }

    private Set<String> loadExtensionsForMediaType(MediaType from) {
        return MimeTypesUtil.getExtensions((String)from.getFullType());
    }

    private String getExtensionWithoutLeadingDot(String extension) {
        if (extension.startsWith(".") && extension.length() > 1) {
            return extension.substring(1);
        }
        return extension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AvailableConversion> getAvailableConversions() {
        List<AvailableConversion> conversions = this.conversionsCache.getAvailableConversionsFromCache();
        if (conversions == null) {
            QetcherConversionsServiceImpl qetcherConversionsServiceImpl = this;
            synchronized (qetcherConversionsServiceImpl) {
                conversions = this.conversionsCache.getAvailableConversionsFromCache();
                if (conversions == null) {
                    conversions = this.loadAvailableConversions();
                    if (conversions == null || conversions.isEmpty()) {
                        LOG.warn("No conversions available");
                        return Collections.emptyList();
                    }
                    this.conversionsCache.putAvailableConversionsToCache(conversions);
                }
            }
        }
        return conversions;
    }

    protected List<AvailableConversion> loadAvailableConversions() {
        return (List)this.clientService.client().getAvailableConversions().join();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getSourceMediaTypesForRegistry(String registry) {
        HashSet<String> result = this.conversionsCache.getSupportedSourceMimeTypesFromCache(registry);
        if (result == null) {
            QetcherConversionsServiceImpl qetcherConversionsServiceImpl = this;
            synchronized (qetcherConversionsServiceImpl) {
                result = this.conversionsCache.getSupportedSourceMimeTypesFromCache(registry);
                if (result == null) {
                    result = this.loadSupportedSourceMimeTypes(registry);
                    this.conversionsCache.putSupportedSourceMimeTypesToCache(registry, result);
                }
            }
        }
        return Collections.unmodifiableSet(result);
    }

    private HashSet<String> loadSupportedSourceMimeTypes(String registry) {
        MediaType registryMediaType = new MediaType(registry, "*");
        List<AvailableConversion> availableConversions = this.getAvailableConversions();
        HashSet<String> mimeTypes = new HashSet<String>();
        for (AvailableConversion availableConversion : availableConversions) {
            MediaType from = availableConversion.getConversion().getFrom();
            if (from.isWildcardType() || from.isWildcardSubtype() || !from.isCompatible(registryMediaType)) continue;
            mimeTypes.add(from.getFullType());
        }
        return mimeTypes;
    }
}

