/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.liferay.client.impl;

import de.mklinger.qetcher.client.model.v1.AvailableConversion;
import de.mklinger.qetcher.client.model.v1.MediaType;
import de.mklinger.qetcher.liferay.abstraction.CacheTool;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={QetcherConversionsCache.class})
public class QetcherConversionsCache {
    private static final String CACHE_NAME = "de.mklinger.qetcher.liferay.ConversionsCache";
    private static final String TARGET_EXTENSIONS_PREFIX = "targetExtensions_";
    private static final String EXTENSIONS_FOR_MEDIA_TYPE_PREFIX = "extensionsForMediaType_";
    private static final String CONVERSIONS_KEY = "conversions";
    private static final String SOURCE_MEDIA_TYPES_REGISTRY_PREFIX = "sourceMediaTypesRegistry_";
    private static final Logger LOG = LoggerFactory.getLogger(QetcherConversionsCache.class);
    private CacheTool cacheTool;

    @Reference
    public void setCacheTool(CacheTool cacheTool) {
        this.cacheTool = cacheTool;
    }

    public String[] getTargetExtensionsFromCache(String extension) {
        String cacheKey = TARGET_EXTENSIONS_PREFIX + extension;
        String[] cachedResult = (String[])this.cacheTool.get(CACHE_NAME, cacheKey);
        if (LOG.isDebugEnabled()) {
            if (cachedResult != null) {
                LOG.debug("Cache hit for {}", (Object)cacheKey);
            } else {
                LOG.debug("Cache miss for {}", (Object)cacheKey);
            }
        }
        return cachedResult;
    }

    public void putTargetExtensionsToCache(String extension, String[] targetExtensions) {
        String cacheKey = TARGET_EXTENSIONS_PREFIX + extension;
        this.cacheTool.put(CACHE_NAME, cacheKey, (Serializable)targetExtensions);
    }

    public Set<String> getExtensionsForMediaTypeFromCache(MediaType from) {
        String cacheKey = EXTENSIONS_FOR_MEDIA_TYPE_PREFIX + from.getFullType();
        Set extensions = (Set)this.cacheTool.get(CACHE_NAME, cacheKey);
        if (LOG.isDebugEnabled()) {
            if (extensions == null) {
                LOG.debug("Cache miss for {}", (Object)cacheKey);
            } else {
                LOG.debug("Cache hit for {}", (Object)cacheKey);
            }
        }
        return extensions;
    }

    public void putExtensionsForMediaTypeToCache(MediaType from, Set<String> extensions) {
        String cacheKey = EXTENSIONS_FOR_MEDIA_TYPE_PREFIX + from.getFullType();
        this.cacheTool.put(CACHE_NAME, cacheKey, (Serializable)((Object)extensions));
    }

    public List<AvailableConversion> getAvailableConversionsFromCache() {
        List conversions = (List)this.cacheTool.get(CACHE_NAME, CONVERSIONS_KEY);
        if (LOG.isDebugEnabled()) {
            if (conversions == null) {
                LOG.debug("Cache miss for {}", (Object)CONVERSIONS_KEY);
            } else {
                LOG.debug("Cache hit for {}", (Object)CONVERSIONS_KEY);
            }
        }
        return conversions;
    }

    public void putAvailableConversionsToCache(List<AvailableConversion> conversions) {
        this.cacheTool.put(CACHE_NAME, CONVERSIONS_KEY, (Serializable)((Object)conversions));
    }

    public HashSet<String> getSupportedSourceMimeTypesFromCache(String registry) {
        String cacheKey = SOURCE_MEDIA_TYPES_REGISTRY_PREFIX + registry;
        HashSet cachedResult = (HashSet)this.cacheTool.get(CACHE_NAME, cacheKey);
        if (LOG.isDebugEnabled()) {
            if (cachedResult != null) {
                LOG.debug("Cache hit for {}", (Object)cacheKey);
            } else {
                LOG.debug("Cache miss for {}", (Object)cacheKey);
            }
        }
        return cachedResult;
    }

    public void putSupportedSourceMimeTypesToCache(String registry, HashSet<String> mimeTypes) {
        String cacheKey = SOURCE_MEDIA_TYPES_REGISTRY_PREFIX + registry;
        this.cacheTool.put(CACHE_NAME, cacheKey, mimeTypes);
    }
}

