package de.mklinger.qetcher.liferay.client.impl.liferay71.scr;

import java.util.Objects;

import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;

public class FilterFactory {
	private static final String RESERVED_CHARACTERS_FOR_KEY = "()&|!=~><*";

	public static String eq(String key, String value) {
		return "(" + requireValidKey(key) + "=" + escapeValue(value) + ")";
	}

	public static String not(String filter) {
		return "(!" + filter + ")";
	}

	public static String and(String... filters) {
		final StringBuilder sb = new StringBuilder();
		sb.append("(&");
		for (final String filter : filters) {
			sb.append(filter);
		}
		sb.append(")");
		return sb.toString();
	}

	public static Filter build(String filter) {
		try {
			return FrameworkUtil.createFilter(filter);
		} catch (final InvalidSyntaxException e) {
			throw new RuntimeException(e);
		}
	}

	private static String requireValidKey(String key) {
		Objects.requireNonNull(key);
		if (RESERVED_CHARACTERS_FOR_KEY.chars()
				.anyMatch(c -> key.indexOf(c) != -1)) {
			throw new IllegalArgumentException("Invalid key: '" + key + "'");
		}
		return key;
	}

	private static String escapeValue(String s) {
		Objects.requireNonNull(s);
		return s
				.replace("*", "\\*")
				.replace("(", "\\(")
				.replace(")", "\\)");
	}
}