package de.mklinger.qetcher.liferay.client.impl.liferay71;

import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.liferay.document.library.kernel.util.DLProcessor;
import com.liferay.document.library.kernel.util.DLProcessorRegistryUtil;
import com.liferay.document.library.kernel.util.VideoProcessor;
import com.liferay.document.library.kernel.util.VideoProcessorUtil;

import de.mklinger.micro.annotations.VisibleForTesting;
import de.mklinger.qetcher.liferay.client.impl.liferay71.scr.ScrServiceOverride;

@Component(immediate = true)
public class QetcherVideoProcessorServiceOverride {
	private static final Logger LOG = LoggerFactory.getLogger(QetcherVideoProcessorServiceOverride.class);

	private BundleContext bundleContext;
	private ScrServiceOverride<VideoProcessor> serviceOverride;

	private DLProcessor originalService;
	private ServiceReference<VideoProcessor> overridingServiceRef;

	@Activate
	public synchronized void activate(BundleContext bundleContext) {
		this.bundleContext = bundleContext;
		this.serviceOverride = new ScrServiceOverride<>(bundleContext,
				VideoProcessor.class,
				"qetcher", "true",
				this::onOverridingServiceAvailable,
				this::onOverridingServiceUnavailable);
	}

	@Deactivate
	public synchronized void deactivate() {
		final ScrServiceOverride<VideoProcessor> override = this.serviceOverride;
		this.serviceOverride = null;
		override.close();
	}

	protected synchronized void onOverridingServiceAvailable(ServiceReference<VideoProcessor> overridingServiceRef) {
		if (this.originalService != null) {
			throw new IllegalStateException();
		}
		if (this.overridingServiceRef != null) {
			throw new IllegalStateException();
		}

		this.overridingServiceRef = overridingServiceRef;

		final DLProcessor overridingService = (DLProcessor) bundleContext.getService(overridingServiceRef);
		if (overridingService == null) {
			LOG.warn("Service unavailable");
		} else {
			LOG.info("Registering service in {}: {}", DLProcessorRegistryUtil.class.getSimpleName(), overridingService);
			originalService = DLProcessorRegistryUtil.getDLProcessor(overridingService.getType());
			DLProcessorRegistryUtil.register(overridingService);
		}
	}

	protected synchronized void onOverridingServiceUnavailable() {
		if (originalService == null) {
			LOG.warn("Unable to restore original service for {}", VideoProcessorUtil.class.getSimpleName());
		} else {
			LOG.info("Restoring original service in {}: {}", DLProcessorRegistryUtil.class.getSimpleName(), originalService);
			DLProcessorRegistryUtil.register(originalService);
			originalService = null;
		}

		bundleContext.ungetService(overridingServiceRef);
	}

	@VisibleForTesting
	protected ScrServiceOverride<VideoProcessor> getServiceOverride() {
		return serviceOverride;
	}
}
