package de.mklinger.qetcher.liferay.client.impl.liferay71;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Properties;

import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.liferay.portal.kernel.util.File;

import de.mklinger.qetcher.client.model.v1.MediaType;
import de.mklinger.qetcher.client.model.v1.MediaTypes;
import de.mklinger.qetcher.liferay.client.QetcherService;

/**
 * @author Marc Klinger - mklinger[at]mklinger[dot]de
 */
@Component(
		immediate = true,
		property = {
				"qetcher:Boolean=true",
				"service.ranking:Integer=1000"
		})
public class QetcherFileImpl implements File {
	private static final MediaType TEXT_FROM = MediaType.valueOf("application/octet-stream");
	private static final MediaType TEXT_TO = MediaTypes.TXT.withParameter("ocrIfAvailable", "true");

	private static final Logger LOG = LoggerFactory.getLogger(QetcherFileImpl.class);

	private File liferayFile;
	private QetcherService qetcherService;

	@Reference(target = "(!(qetcher=true))")
	public void setLiferayFile(File liferayFile) {
		this.liferayFile = liferayFile;
	}

	@Reference
	public void setQetcherService(QetcherService qetcherService) {
		this.qetcherService = qetcherService;
	}

	@Override
	public String extractText(InputStream is, String fileName) {
		return extractText(is, fileName, -1);
	}

	@Override
	public String extractText(InputStream is, String fileName, int maxStringLength) {
		try {
			return doExtractText(is, fileName, maxStringLength);
		} catch (final Exception e) {
			LOG.warn("Error extracting text from file with name '{}' using Qetcher", fileName, e);
			return "";
		}
	}

	private String doExtractText(InputStream is, String fileName, int maxStringLength) {
		if (maxStringLength == 0) {
			return "";
		}

		final String referrer = "liferay-extract-text-filename=" + fileName;

		LOG.info("Starting text extraction for file with name '{}'", fileName);

		final byte[] text = qetcherService.convertToByteArray(
				is,
				TEXT_FROM,
				TEXT_TO,
				referrer);

		if (maxStringLength > 0 && text.length > maxStringLength) {
			// We actually don't apply string length, but number of bytes. That's ok for me.
			return new String(text, 0, maxStringLength, StandardCharsets.UTF_8);
		} else {
			return new String(text, StandardCharsets.UTF_8);
		}
	}

	// ---- delegating methods: ----

	@Override
	public String appendParentheticalSuffix(String fileName, String suffix) {
		return liferayFile.appendParentheticalSuffix(fileName, suffix);
	}

	@Override
	public String appendSuffix(String fileName, String suffix) {
		return liferayFile.appendSuffix(fileName, suffix);
	}

	@Override
	public void copyDirectory(java.io.File source, java.io.File destination) throws IOException {
		liferayFile.copyDirectory(source, destination);
	}

	@Override
	public void copyDirectory(String sourceDirName, String destinationDirName) throws IOException {
		liferayFile.copyDirectory(sourceDirName, destinationDirName);
	}

	@Override
	public void copyFile(java.io.File source, java.io.File destination) throws IOException {
		liferayFile.copyFile(source, destination);
	}

	@Override
	public void copyFile(java.io.File source, java.io.File destination, boolean lazy) throws IOException {
		liferayFile.copyFile(source, destination, lazy);
	}

	@Override
	public void copyFile(String source, String destination) throws IOException {
		liferayFile.copyFile(source, destination);
	}

	@Override
	public void copyFile(String source, String destination, boolean lazy) throws IOException {
		liferayFile.copyFile(source, destination, lazy);
	}

	@Override
	public java.io.File createTempFile() {
		return liferayFile.createTempFile();
	}

	@Override
	public java.io.File createTempFile(byte[] bytes) throws IOException {
		return liferayFile.createTempFile(bytes);
	}

	@Override
	public java.io.File createTempFile(InputStream is) throws IOException {
		return liferayFile.createTempFile(is);
	}

	@Override
	public java.io.File createTempFile(String extension) {
		return liferayFile.createTempFile(extension);
	}

	@Override
	public java.io.File createTempFile(String prefix, String extension) {
		return liferayFile.createTempFile(prefix, extension);
	}

	@Override
	public String createTempFileName() {
		return liferayFile.createTempFileName();
	}

	@Override
	public String createTempFileName(String extension) {
		return liferayFile.createTempFileName(extension);
	}

	@Override
	public String createTempFileName(String prefix, String extension) {
		return liferayFile.createTempFileName(prefix, extension);
	}

	@Override
	public java.io.File createTempFolder() throws IOException {
		return liferayFile.createTempFolder();
	}

	@Override
	public String decodeSafeFileName(String fileName) {
		return liferayFile.decodeSafeFileName(fileName);
	}

	@Override
	public boolean delete(java.io.File file) {
		return liferayFile.delete(file);
	}

	@Override
	public boolean delete(String file) {
		return liferayFile.delete(file);
	}

	@Override
	public void deltree(java.io.File directory) {
		liferayFile.deltree(directory);
	}

	@Override
	public void deltree(String directory) {
		liferayFile.deltree(directory);
	}

	@Override
	public String encodeSafeFileName(String fileName) {
		return liferayFile.encodeSafeFileName(fileName);
	}

	@Override
	public boolean exists(java.io.File file) {
		return liferayFile.exists(file);
	}

	@Override
	public boolean exists(String fileName) {
		return liferayFile.exists(fileName);
	}

	@Override
	public String[] find(String directory, String includes, String excludes) {
		return liferayFile.find(directory, includes, excludes);
	}

	@Override
	public String getAbsolutePath(java.io.File file) {
		return liferayFile.getAbsolutePath(file);
	}

	@Override
	public byte[] getBytes(Class<?> clazz, String fileName) throws IOException {
		return liferayFile.getBytes(clazz, fileName);
	}

	@Override
	public byte[] getBytes(InputStream is) throws IOException {
		return liferayFile.getBytes(is);
	}

	@Override
	public byte[] getBytes(InputStream is, int bufferSize) throws IOException {
		return liferayFile.getBytes(is, bufferSize);
	}

	@Override
	public byte[] getBytes(InputStream inputStream, int bufferSize, boolean cleanUpStream) throws IOException {
		return liferayFile.getBytes(inputStream, bufferSize, cleanUpStream);
	}

	@Override
	public byte[] getBytes(java.io.File file) throws IOException {
		return liferayFile.getBytes(file);
	}

	@Override
	public String getExtension(String fileName) {
		return liferayFile.getExtension(fileName);
	}

	@Override
	public String getMD5Checksum(java.io.File file) throws IOException {
		return liferayFile.getMD5Checksum(file);
	}

	@Override
	public String getPath(String fullFileName) {
		return liferayFile.getPath(fullFileName);
	}

	@Override
	public String getShortFileName(String fullFileName) {
		return liferayFile.getShortFileName(fullFileName);
	}

	@Override
	public boolean isAscii(java.io.File file) throws IOException {
		return liferayFile.isAscii(file);
	}

	@Override
	public boolean isSameContent(java.io.File file, byte[] bytes, int length) {
		return liferayFile.isSameContent(file, bytes, length);
	}

	@Override
	public boolean isSameContent(java.io.File file, String s) {
		return liferayFile.isSameContent(file, s);
	}

	@Override
	public String[] listDirs(java.io.File file) {
		return liferayFile.listDirs(file);
	}

	@Override
	public String[] listDirs(String fileName) {
		return liferayFile.listDirs(fileName);
	}

	@Override
	public String[] listFiles(java.io.File file) {
		return liferayFile.listFiles(file);
	}

	@Override
	public String[] listFiles(String fileName) {
		return liferayFile.listFiles(fileName);
	}

	@Override
	public void mkdirs(java.io.File file) throws IOException {
		liferayFile.mkdirs(file);
	}

	@Override
	public void mkdirs(String pathName) {
		liferayFile.mkdirs(pathName);
	}

	@Override
	public boolean move(java.io.File source, java.io.File destination) {
		return liferayFile.move(source, destination);
	}

	@Override
	public boolean move(String sourceFileName, String destinationFileName) {
		return liferayFile.move(sourceFileName, destinationFileName);
	}

	@Override
	public String read(java.io.File file) throws IOException {
		return liferayFile.read(file);
	}

	@Override
	public String read(java.io.File file, boolean raw) throws IOException {
		return liferayFile.read(file, raw);
	}

	@Override
	public String read(String fileName) throws IOException {
		return liferayFile.read(fileName);
	}

	@Override
	public String replaceSeparator(String fileName) {
		return liferayFile.replaceSeparator(fileName);
	}

	@Override
	public java.io.File[] sortFiles(java.io.File[] files) {
		return liferayFile.sortFiles(files);
	}

	@Override
	public String stripExtension(String fileName) {
		return liferayFile.stripExtension(fileName);
	}

	@Override
	public String stripParentheticalSuffix(String fileName) {
		return liferayFile.stripParentheticalSuffix(fileName);
	}

	@Override
	public List<String> toList(Reader reader) {
		return liferayFile.toList(reader);
	}

	@Override
	public List<String> toList(String fileName) {
		return liferayFile.toList(fileName);
	}

	@Override
	public Properties toProperties(FileInputStream fis) {
		return liferayFile.toProperties(fis);
	}

	@Override
	public Properties toProperties(String fileName) {
		return liferayFile.toProperties(fileName);
	}

	@Override
	public void touch(java.io.File file) throws IOException {
		liferayFile.touch(file);
	}

	@Override
	public void touch(String fileName) throws IOException {
		liferayFile.touch(fileName);
	}

	@Override
	public void unzip(java.io.File source, java.io.File destination) {
		liferayFile.unzip(source, destination);
	}

	@Override
	public void write(java.io.File file, byte[] bytes) throws IOException {
		liferayFile.write(file, bytes);
	}

	@Override
	public void write(java.io.File file, byte[] bytes, boolean append) throws IOException {
		liferayFile.write(file, bytes, append);
	}

	@Override
	public void write(java.io.File file, byte[] bytes, int offset, int length) throws IOException {
		liferayFile.write(file, bytes, offset, length);
	}

	@Override
	public void write(java.io.File file, byte[] bytes, int offset, int length, boolean append) throws IOException {
		liferayFile.write(file, bytes, offset, length, append);
	}

	@Override
	public void write(java.io.File file, InputStream is) throws IOException {
		liferayFile.write(file, is);
	}

	@Override
	public void write(java.io.File file, String s) throws IOException {
		liferayFile.write(file, s);
	}

	@Override
	public void write(java.io.File file, String s, boolean lazy) throws IOException {
		liferayFile.write(file, s, lazy);
	}

	@Override
	public void write(java.io.File file, String s, boolean lazy, boolean append) throws IOException {
		liferayFile.write(file, s, lazy, append);
	}

	@Override
	public void write(String fileName, byte[] bytes) throws IOException {
		liferayFile.write(fileName, bytes);
	}

	@Override
	public void write(String fileName, InputStream is) throws IOException {
		liferayFile.write(fileName, is);
	}

	@Override
	public void write(String fileName, String s) throws IOException {
		liferayFile.write(fileName, s);
	}

	@Override
	public void write(String fileName, String s, boolean lazy) throws IOException {
		liferayFile.write(fileName, s, lazy);
	}

	@Override
	public void write(String fileName, String s, boolean lazy, boolean append) throws IOException {
		liferayFile.write(fileName, s, lazy, append);
	}

	@Override
	public void write(String pathName, String fileName, String s) throws IOException {
		liferayFile.write(pathName, fileName, s);
	}

	@Override
	public void write(String pathName, String fileName, String s, boolean lazy) throws IOException {
		liferayFile.write(pathName, fileName, s, lazy);
	}

	@Override
	public void write(String pathName, String fileName, String s, boolean lazy, boolean append) throws IOException {
		liferayFile.write(pathName, fileName, s, lazy, append);
	}
}
