package de.mklinger.qetcher.liferay.client.impl.liferay71;

import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.liferay.document.library.kernel.util.AudioProcessor;
import com.liferay.document.library.kernel.util.AudioProcessorUtil;
import com.liferay.document.library.kernel.util.DLProcessor;
import com.liferay.document.library.kernel.util.DLProcessorRegistryUtil;

import de.mklinger.micro.annotations.VisibleForTesting;
import de.mklinger.qetcher.liferay.client.impl.liferay71.scr.ScrServiceOverride;

@Component(immediate = true)
public class QetcherAudioProcessorServiceOverride {
	private static final Logger LOG = LoggerFactory.getLogger(QetcherAudioProcessorServiceOverride.class);

	private BundleContext bundleContext;
	private ScrServiceOverride<AudioProcessor> serviceOverride;

	private DLProcessor originalService;
	private ServiceReference<AudioProcessor> overridingServiceRef;

	@Activate
	public synchronized void activate(BundleContext bundleContext) {
		this.bundleContext = bundleContext;
		this.serviceOverride = new ScrServiceOverride<>(bundleContext,
				AudioProcessor.class,
				"qetcher", "true",
				this::onOverridingServiceAvailable,
				this::onOverridingServiceUnavailable);
	}

	@Deactivate
	public synchronized void deactivate() {
		final ScrServiceOverride<AudioProcessor> override = this.serviceOverride;
		this.serviceOverride = null;
		override.close();
	}

	protected synchronized void onOverridingServiceAvailable(ServiceReference<AudioProcessor> overridingServiceRef) {
		if (this.originalService != null) {
			throw new IllegalStateException();
		}
		if (this.overridingServiceRef != null) {
			throw new IllegalStateException();
		}

		this.overridingServiceRef = overridingServiceRef;

		final DLProcessor overridingService = (DLProcessor) bundleContext.getService(overridingServiceRef);
		if (overridingService == null) {
			LOG.warn("Service unavailable");
		} else {
			LOG.info("Registering service in {}: {}", DLProcessorRegistryUtil.class.getSimpleName(), overridingService);
			originalService = DLProcessorRegistryUtil.getDLProcessor(overridingService.getType());
			DLProcessorRegistryUtil.register(overridingService);
		}
	}

	protected synchronized void onOverridingServiceUnavailable() {
		if (originalService == null) {
			LOG.warn("Unable to restore original service for {}", AudioProcessorUtil.class.getSimpleName());
		} else {
			LOG.info("Restoring original service in {}: {}", DLProcessorRegistryUtil.class.getSimpleName(), originalService);
			DLProcessorRegistryUtil.register(originalService);
			originalService = null;
		}

		bundleContext.ungetService(overridingServiceRef);
	}

	@VisibleForTesting
	protected ScrServiceOverride<AudioProcessor> getServiceOverride() {
		return serviceOverride;
	}
}
