package de.mklinger.qetcher.liferay.client.impl.liferay71;

import java.util.HashSet;
import java.util.Set;

public class MultiLock {
	private final Set<Object> lockedKeys = new HashSet<>();

	public Lock lock(Object key) {
		synchronized (lockedKeys) {
			while (!lockedKeys.add(key)) {
				try {
					lockedKeys.wait();
				} catch (final InterruptedException e) {
					Thread.currentThread().interrupt();
					throw new RuntimeException("Interrupted", e);
				}
			}
			return new Lock(key);
		}
	}

	private void unlock(Object key) {
		synchronized (lockedKeys) {
			lockedKeys.remove(key);
			lockedKeys.notifyAll();
		}
	}

	public class Lock implements AutoCloseable {
		private final Object key;

		public Lock(Object key) {
			this.key = key;
		}

		@Override
		public void close() {
			unlock(key);
		}
	}
}
