package de.mklinger.qetcher.liferay.client;

import java.io.InputStream;
import java.nio.file.Path;
import java.util.List;
import java.util.function.Function;

import de.mklinger.qetcher.client.model.v1.AvailableConversion;
import de.mklinger.qetcher.client.model.v1.MediaType;

/**
 * @author Marc Klinger - mklinger[at]mklinger[dot]de
 */
public interface QetcherService {
	Path convertToFile(final InputStream inputStream, Path targetFile, final MediaType fromMediaType, final MediaType toMediaType, String referrer);
	List<Path> convertToFiles(final InputStream inputStream, Function<Integer, Path> targetFileSupplier, final MediaType fromMediaType, final MediaType toMediaType, String referrer);
	Path convertToTempFile(final InputStream inputStream, final MediaType fromMediaType, final MediaType toMediaType, String referrer);
	byte[] convertToByteArray(final InputStream inputStream, final MediaType fromMediaType, final MediaType toMediaType, String referrer);

	List<AvailableConversion> getAvailableConversions();
}
