package de.mklinger.qetcher.liferay.client.impl.liferay71;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

import de.mklinger.qetcher.client.QetcherClientException;
import de.mklinger.qetcher.liferay.client.impl.liferay71.QetcherTimeoutConfig.TimeValue;

@Component(service = QetcherTimeoutGet.class)
public class QetcherTimeoutGet {
	@Reference
	private QetcherTimeoutConfig timeoutConfig;

	// Still no constructor injection?
	//	public QetcherTimeoutGet(QetcherTimeoutConfig timeoutConfig) {
	//		this.timeoutConfig = timeoutConfig;
	//	}

	public <T> T getWithShortTimeout(final CompletableFuture<T> future) {
		return get(future, timeoutConfig.getShortTimeout());
	}

	public <T> T getWithUploadTimeout(final CompletableFuture<T> future) {
		return get(future, timeoutConfig.getUploadTimeout());
	}

	public <T> T getWithDownloadTimeout(final CompletableFuture<T> future) {
		return get(future, timeoutConfig.getDownloadTimeout());
	}

	private <T> T get(final CompletableFuture<T> future, TimeValue timeout) {
		return get(future, timeout.time(), timeout.unit());
	}

	private <T> T get(final CompletableFuture<T> future, final long timeout, final TimeUnit timeoutUnit) {
		try {
			return future.get(timeout, timeoutUnit);
		} catch (final InterruptedException e) {
			Thread.currentThread().interrupt();
			throw new QetcherClientException("Qetcher client interrupted", e);
		} catch (final TimeoutException e) {
			throw new QetcherClientException("Qetcher client timeout after " + timeout + " " + timeoutUnit, e);
		} catch (final ExecutionException e) {
			throw new QetcherClientException("Qetcher client error", e);
		}
	}

}
