package de.mklinger.qetcher.liferay.client.impl.liferay71;

import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.liferay.portal.kernel.util.File;
import com.liferay.portal.kernel.util.FileUtil;

import de.mklinger.qetcher.liferay.client.impl.liferay71.scr.ScrServiceOverride;

@Component(immediate = true)
public class QetcherFileServiceOverride {
	private static final Logger LOG = LoggerFactory.getLogger(QetcherFileServiceOverride.class);

	private BundleContext bundleContext;
	private ScrServiceOverride<File> serviceOverride;

	private File originalService;
	private ServiceReference<File> overridingServiceRef;

	@Activate
	public synchronized void activate(BundleContext bundleContext) {
		this.bundleContext = bundleContext;
		this.serviceOverride = new ScrServiceOverride<>(bundleContext,
				File.class,
				"qetcher", "true",
				this::onOverridingServiceAvailable,
				this::onOverridingServiceUnavailable);
	}

	@Deactivate
	public synchronized void deactivate() {
		final ScrServiceOverride<File> override = this.serviceOverride;
		this.serviceOverride = null;
		override.close();
	}

	protected synchronized void onOverridingServiceAvailable(ServiceReference<File> overridingServiceRef) {
		if (this.originalService != null) {
			throw new IllegalStateException();
		}
		if (this.overridingServiceRef != null) {
			throw new IllegalStateException();
		}

		this.overridingServiceRef = overridingServiceRef;

		final File overridingService = bundleContext.getService(overridingServiceRef);
		if (overridingService == null) {
			LOG.warn("Service unavailable");
		} else {
			LOG.info("Using service for {}: {}", FileUtil.class.getSimpleName(), overridingService);
			originalService = FileUtil.getFile();
			new FileUtil().setFile(overridingService);
		}
	}

	protected synchronized void onOverridingServiceUnavailable() {
		if (originalService == null) {
			LOG.warn("Unable to restore original service for {}", FileUtil.class.getSimpleName());
		} else {
			LOG.info("Restoring original service for {}: {}", FileUtil.class.getSimpleName(), originalService);
			new FileUtil().setFile(originalService);
			originalService = null;
		}

		bundleContext.ungetService(overridingServiceRef);
	}
}
