package de.mklinger.qetcher.liferay.client.impl.liferay71;

import org.osgi.service.component.annotations.Component;

import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.util.MimeTypesUtil;

import de.mklinger.micro.annotations.VisibleForTesting;
import de.mklinger.qetcher.client.model.v1.MediaType;

@Component(service = ProcessorMediaTypes.class)
public class ProcessorMediaTypes {
	public MediaType getMediaType(FileVersion fileVersion) {
		String mimeType = fileVersion.getMimeType();
		if (mimeType != null && !mimeType.isEmpty()) {
			return MediaType.valueOf(mimeType);
		}

		String extension = fileVersion.getExtension();
		if (extension != null && !extension.isEmpty()) {
			if (extension.startsWith(".") && extension.length() > 1) {
				extension = extension.substring(1);
			}

			mimeType = getExtensionContentType(extension);
			if (mimeType != null && !mimeType.isEmpty()) {
				return MediaType.valueOf(mimeType);
			}
		}

		throw new IllegalArgumentException("Unable to detect media type for file version " + fileVersion.getFileVersionId());
	}

	public MediaType getContainerMediaType(String containerType) {
		final String contentType = getExtensionContentType(containerType);

		if (contentType == null || contentType.isEmpty()) {
			throw new IllegalArgumentException("Unable to detect media type for container type " + containerType);
		}

		return MediaType.valueOf(contentType);
	}

	@VisibleForTesting
	protected String getExtensionContentType(String extension) {
		return MimeTypesUtil.getExtensionContentType(extension);
	}
}
