/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.liferay.client.impl.liferay71;

import com.liferay.document.library.kernel.document.conversion.DocumentConversionUtil;
import com.liferay.document.library.kernel.store.DLStoreUtil;
import com.liferay.document.library.kernel.util.DLPreviewableProcessor;
import com.liferay.document.library.kernel.util.PDFProcessor;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Element;
import java.io.InputStream;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class QetcherPDFProcessorImplBoilerplate
extends DLPreviewableProcessor
implements PDFProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(QetcherPDFProcessorImplBoilerplate.class);
    private final boolean fileEntryPreviewEnabled;
    private final boolean fileEntryThumbnailEnabled;
    private final int previewDocumentDocumentDpi;
    protected final List<Long> fileVersionIds = new Vector<Long>();

    public QetcherPDFProcessorImplBoilerplate() {
        this.fileEntryPreviewEnabled = GetterUtil.getBoolean((String)PropsUtil.get((String)"dl.file.entry.preview.enabled"));
        this.fileEntryThumbnailEnabled = GetterUtil.getBoolean((String)PropsUtil.get((String)"dl.file.entry.thumbnail.enabled"));
        this.previewDocumentDocumentDpi = GetterUtil.getInteger((String)PropsUtil.get((String)"dl.file.entry.preview.document.dpi"));
    }

    public void afterPropertiesSet() throws Exception {
        FileUtil.mkdirs((String)DECRYPT_TMP_PATH);
        FileUtil.mkdirs((String)PREVIEW_TMP_PATH);
        FileUtil.mkdirs((String)THUMBNAIL_TMP_PATH);
    }

    public void destroy() {
        FileUtil.deltree((String)TMP_PATH);
    }

    public String getType() {
        return "PDFProcessor";
    }

    public InputStream getPreviewAsStream(FileVersion fileVersion, int index) throws Exception {
        return this.doGetPreviewAsStream(fileVersion, index, "png");
    }

    public int getPreviewFileCount(FileVersion fileVersion) {
        try {
            return this.doGetPreviewFileCount(fileVersion);
        }
        catch (Exception e) {
            LOG.error("Error in super.doGetPreviewFileCount()", (Throwable)e);
            return 0;
        }
    }

    public long getPreviewFileSize(FileVersion fileVersion, int index) throws Exception {
        return this.doGetPreviewFileSize(fileVersion, index);
    }

    public InputStream getThumbnailAsStream(FileVersion fileVersion, int index) throws Exception {
        return this.doGetThumbnailAsStream(fileVersion, index);
    }

    public long getThumbnailFileSize(FileVersion fileVersion, int index) throws Exception {
        return this.doGetThumbnailFileSize(fileVersion, index);
    }

    public boolean hasImages(FileVersion fileVersion) {
        boolean hasImages = false;
        try {
            hasImages = this._hasImages(fileVersion);
            if (!hasImages && this.isSupported(fileVersion)) {
                this.queueGeneration(null, fileVersion);
            }
        }
        catch (Exception e) {
            LOG.error("Error in hasImages()", (Throwable)e);
        }
        return hasImages;
    }

    public boolean isDocumentSupported(FileVersion fileVersion) {
        return this.isSupported(fileVersion);
    }

    public boolean isDocumentSupported(String mimeType) {
        return this.isSupported(mimeType);
    }

    public boolean isSupported(String mimeType) {
        if (Validator.isNull((String)mimeType)) {
            return false;
        }
        if (mimeType.equals("application/pdf") || mimeType.equals("application/x-pdf")) {
            return true;
        }
        if (DocumentConversionUtil.isEnabled()) {
            Set extensions = MimeTypesUtil.getExtensions((String)mimeType);
            for (String extension : extensions) {
                String[] targetExtensions;
                extension = this.withoutLeadingDot(extension);
                for (String targetExtension : targetExtensions = DocumentConversionUtil.getConversions((String)extension)) {
                    if (!"pdf".equals(this.withoutLeadingDot(targetExtension))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private String withoutLeadingDot(String s) {
        if (s == null || s.length() < 2) {
            return s;
        }
        if (s.startsWith(".")) {
            return s.substring(1);
        }
        return s;
    }

    protected void doExportGeneratedFiles(PortletDataContext portletDataContext, FileEntry fileEntry, Element fileEntryElement) throws Exception {
        this.exportThumbnails(portletDataContext, fileEntry, fileEntryElement, "pdf");
        this.exportPreviews(portletDataContext, fileEntry, fileEntryElement);
    }

    protected void exportPreviews(PortletDataContext portletDataContext, FileEntry fileEntry, Element fileEntryElement) throws Exception {
        FileVersion fileVersion = fileEntry.getFileVersion();
        if (!this.isSupported(fileVersion) || !this._hasImages(fileVersion)) {
            return;
        }
        if (!portletDataContext.isPerformDirectBinaryImport()) {
            int previewFileCount = this.getPreviewFileCount(fileVersion);
            fileEntryElement.addAttribute("bin-path-pdf-preview-count", String.valueOf(previewFileCount));
            for (int i = 0; i < previewFileCount; ++i) {
                this.exportPreview(portletDataContext, fileEntry, fileEntryElement, "pdf", "png", i);
            }
        }
    }

    protected boolean _hasImages(FileVersion fileVersion) throws Exception {
        if (this.fileEntryPreviewEnabled && !this.hasPreview(fileVersion)) {
            return false;
        }
        return this.hasThumbnails(fileVersion);
    }

    protected boolean hasPreview(FileVersion fileVersion) throws Exception {
        return this.hasPreview(fileVersion, null);
    }

    protected boolean hasPreview(FileVersion fileVersion, String type) throws Exception {
        String previewFilePath = this.getPreviewFilePath(fileVersion, 1);
        return DLStoreUtil.hasFile((long)fileVersion.getCompanyId(), (long)0L, (String)previewFilePath);
    }

    protected void doImportGeneratedFiles(PortletDataContext portletDataContext, FileEntry fileEntry, FileEntry importedFileEntry, Element fileEntryElement) throws Exception {
        this.importThumbnails(portletDataContext, fileEntry, importedFileEntry, fileEntryElement, "pdf");
        this.importPreviews(portletDataContext, fileEntry, importedFileEntry, fileEntryElement);
    }

    protected void importPreviews(PortletDataContext portletDataContext, FileEntry fileEntry, FileEntry importedFileEntry, Element fileEntryElement) throws Exception {
        int previewFileCount = GetterUtil.getInteger((String)fileEntryElement.attributeValue("bin-path-pdf-preview-count"));
        for (int i = 0; i < previewFileCount; ++i) {
            this.importPreview(portletDataContext, fileEntry, importedFileEntry, fileEntryElement, "pdf", "png", i);
        }
    }

    protected List<Long> getFileVersionIds() {
        return this.fileVersionIds;
    }

    protected String getPreviewType(FileVersion fileVersion) {
        return "png";
    }

    protected String getThumbnailType(FileVersion fileVersion) {
        return "png";
    }

    private void queueGeneration(FileVersion sourceFileVersion, FileVersion destinationFileVersion) {
        if (this.fileVersionIds.contains(destinationFileVersion.getFileVersionId())) {
            return;
        }
        boolean generateImages = false;
        String extension = destinationFileVersion.getExtension();
        if (extension.equals("pdf")) {
            generateImages = true;
        } else if (DocumentConversionUtil.isEnabled()) {
            String[] conversions;
            for (String conversion : conversions = DocumentConversionUtil.getConversions((String)extension)) {
                if (!conversion.equals("pdf")) continue;
                generateImages = true;
                break;
            }
        }
        if (generateImages) {
            this.fileVersionIds.add(destinationFileVersion.getFileVersionId());
            this.sendGenerationMessage("liferay/document_library_pdf_processor", sourceFileVersion, destinationFileVersion);
        }
    }

    protected boolean _isGeneratePreview(FileVersion fileVersion) throws Exception {
        return this.fileEntryPreviewEnabled && !this.hasPreview(fileVersion);
    }

    protected boolean _isGenerateThumbnail(FileVersion fileVersion) throws Exception {
        return this.fileEntryThumbnailEnabled && !this.hasThumbnail(fileVersion, 0);
    }

    protected int getPreviewDocumentDocumentDpi() {
        return this.previewDocumentDocumentDpi;
    }
}

