/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.liferay.client.impl.liferay71;

import com.liferay.document.library.kernel.document.conversion.DocumentConversionUtil;
import com.liferay.document.library.kernel.exception.NoSuchFileEntryException;
import com.liferay.document.library.kernel.util.DLUtil;
import com.liferay.document.library.kernel.util.PDFProcessor;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.util.FileUtil;
import de.mklinger.qetcher.client.model.v1.MediaType;
import de.mklinger.qetcher.client.model.v1.MediaTypes;
import de.mklinger.qetcher.liferay.client.QetcherService;
import de.mklinger.qetcher.liferay.client.impl.liferay71.QetcherPDFProcessorImplBoilerplate;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, property={"qetcher:Boolean=true", "service.ranking:Integer=1000"})
public class QetcherPDFProcessorImpl
extends QetcherPDFProcessorImplBoilerplate
implements PDFProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(QetcherPDFProcessorImpl.class);
    private QetcherService qetcherService;

    @Reference
    public void setQetcherService(QetcherService qetcherService) {
        this.qetcherService = qetcherService;
    }

    @Override
    @Activate
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateImages(FileVersion sourceFileVersion, FileVersion destinationFileVersion) throws Exception {
        block50: {
            try {
                File pdfFile;
                Throwable throwable;
                if (sourceFileVersion != null) {
                    this.copy(sourceFileVersion, destinationFileVersion);
                    return;
                }
                if (this._hasImages(destinationFileVersion)) {
                    return;
                }
                String extension = destinationFileVersion.getExtension();
                if (extension.equals("pdf")) {
                    try (InputStream inputStream = destinationFileVersion.getContentStream(false);){
                        this.generateImages(destinationFileVersion, inputStream);
                        break block50;
                    }
                }
                if (!DocumentConversionUtil.isEnabled()) break block50;
                String tempFileId = DLUtil.getTempFileId((long)destinationFileVersion.getFileEntryId(), (String)destinationFileVersion.getVersion());
                if (Objects.equals("PWC", destinationFileVersion.getVersion()) || destinationFileVersion.isPending()) {
                    File file = new File(DocumentConversionUtil.getFilePath((String)tempFileId, (String)"pdf"));
                    FileUtil.delete((File)file);
                }
                try {
                    throwable = null;
                    try (InputStream inputStream = destinationFileVersion.getContentStream(false);){
                        pdfFile = DocumentConversionUtil.convert((String)tempFileId, (InputStream)inputStream, (String)extension, (String)"pdf");
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                catch (Exception e) {
                    LOG.info("Conversion from {} to {} failed. Not generating images.", (Object)extension, (Object)"pdf");
                    pdfFile = null;
                }
                if (pdfFile == null) break block50;
                throwable = null;
                try (FileInputStream in = new FileInputStream(pdfFile);){
                    this.generateImages(destinationFileVersion, in);
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            catch (NoSuchFileEntryException nsfee) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("File not found", (Throwable)nsfee);
                }
            }
            finally {
                this.fileVersionIds.remove(destinationFileVersion.getFileVersionId());
            }
        }
    }

    private void generateImages(FileVersion fileVersion, InputStream pdfInputStream) throws Exception {
        MediaType fromMediaType = MediaTypes.PDF;
        MediaType toMediaType = MediaTypes.PNG.withParameter("resolution", String.valueOf(this.getPreviewDocumentDocumentDpi()));
        String tempFileId = this.getTempFileId(fileVersion);
        String referrer = "liferay-pdfprocessor-id=" + tempFileId;
        if (this._isGeneratePreview(fileVersion)) {
            Function<Integer, Path> targetFileSupplier = idx -> this.getPreviewTempFile(tempFileId, idx + 2).toPath();
            List<Path> previewFiles = this.qetcherService.convertToFiles(pdfInputStream, targetFileSupplier, fromMediaType, toMediaType, referrer);
            if (this._isGenerateThumbnail(fileVersion) && !previewFiles.isEmpty()) {
                this.storeThumbnailImages(fileVersion, previewFiles.get(0).toFile());
            }
            this.addPreviewFilesToStore(fileVersion, tempFileId);
        } else if (this._isGenerateThumbnail(fileVersion)) {
            MediaType thumbnailToMediaType = toMediaType.withParameter("pages", "1");
            Path targetFile = this.getThumbnailTempFile(tempFileId).toPath();
            this.qetcherService.convertToFile(pdfInputStream, targetFile, fromMediaType, thumbnailToMediaType, referrer);
            this.addThumbnailToStore(fileVersion, tempFileId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addThumbnailToStore(FileVersion fileVersion, String tempFileId) throws Exception {
        File thumbnailTempFile = this.getThumbnailTempFile(tempFileId);
        try {
            this.storeThumbnailImages(fileVersion, thumbnailTempFile);
        }
        finally {
            FileUtil.delete((File)thumbnailTempFile);
        }
    }

    private String getTempFileId(FileVersion fileVersion) {
        return DLUtil.getTempFileId((long)fileVersion.getFileEntryId(), (String)fileVersion.getVersion());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPreviewFilesToStore(FileVersion fileVersion, String tempFileId) throws PortalException {
        int total = this.getPreviewTempFileCount(fileVersion);
        for (int i = 0; i < total; ++i) {
            File previewTempFile = this.getPreviewTempFile(tempFileId, i + 2);
            try {
                String previewFilePath = this.getPreviewFilePath(fileVersion, i + 1);
                LOG.debug("Adding preview file to store: idx {}, file {}", (Object)i, (Object)previewFilePath);
                this.addFileToStore(fileVersion.getCompanyId(), "document_preview/", previewFilePath, previewTempFile);
                continue;
            }
            finally {
                FileUtil.delete((File)previewTempFile);
            }
        }
    }
}

