/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.liferay.client.impl.liferay71;

import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import de.mklinger.micro.annotations.VisibleForTesting;
import de.mklinger.qetcher.client.model.v1.MediaType;
import org.osgi.service.component.annotations.Component;

@Component(service={ProcessorMediaTypes.class})
public class ProcessorMediaTypes {
    public MediaType getMediaType(FileVersion fileVersion) {
        String mimeType = fileVersion.getMimeType();
        if (mimeType != null && !mimeType.isEmpty()) {
            return MediaType.valueOf((String)mimeType);
        }
        String extension = fileVersion.getExtension();
        if (extension != null && !extension.isEmpty()) {
            if (extension.startsWith(".") && extension.length() > 1) {
                extension = extension.substring(1);
            }
            if ((mimeType = this.getExtensionContentType(extension)) != null && !mimeType.isEmpty()) {
                return MediaType.valueOf((String)mimeType);
            }
        }
        throw new IllegalArgumentException("Unable to detect media type for file version " + fileVersion.getFileVersionId());
    }

    public MediaType getContainerMediaType(String containerType) {
        String contentType = this.getExtensionContentType(containerType);
        if (contentType == null || contentType.isEmpty()) {
            throw new IllegalArgumentException("Unable to detect media type for container type " + containerType);
        }
        return MediaType.valueOf((String)contentType);
    }

    @VisibleForTesting
    protected String getExtensionContentType(String extension) {
        return MimeTypesUtil.getExtensionContentType((String)extension);
    }
}

