/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.liferay.client.impl;

import de.mklinger.qetcher.client.InputJob;
import de.mklinger.qetcher.client.QetcherClientException;
import de.mklinger.qetcher.client.QetcherRemoteException;
import de.mklinger.qetcher.client.common.concurrent.Delay;
import de.mklinger.qetcher.client.model.v1.Job;
import de.mklinger.qetcher.client.model.v1.JobState;
import de.mklinger.qetcher.liferay.client.QetcherClientService;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={QetcherJobs.class})
public class QetcherJobs {
    private static final int JOB_CREATE_TIMEOUT_SECONDS = 30;
    private static final int JOB_WAIT_TIMEOUT_MINUTES = 30;
    private static final Logger LOG = LoggerFactory.getLogger(QetcherJobs.class);
    private QetcherClientService clientService;

    @Reference
    public void setClientService(QetcherClientService clientService) {
        this.clientService = clientService;
    }

    public CompletableFuture<Job> createJobWithTimeout(InputJob inputJob) {
        return Delay.timeout((CompletableFuture)this.clientService.client().createJob(inputJob), (long)30L, (TimeUnit)TimeUnit.SECONDS, () -> new TimeoutException("Timeout creating job: " + inputJob.getFromMediaType() + " -> " + inputJob.getToMediaType()));
    }

    public CompletableFuture<Job> getJobDoneWithTimeout(Job job) {
        return Delay.timeout((CompletableFuture)this.clientService.client().getJobDone(job), (long)30L, (TimeUnit)TimeUnit.MINUTES, () -> new TimeoutException("Timeout getting job done " + job.getJobId() + " " + job.getFromMediaType() + " -> " + job.getToMediaType()));
    }

    public Job requireSuccess(Job job) {
        if (job.getState() != JobState.SUCCESS) {
            QetcherRemoteException cause = job.getError() != null ? new QetcherRemoteException(job.getError(), -1) : null;
            throw new QetcherClientException("Job " + job.getJobId() + " is not in state SUCCESS but " + job.getState(), (Throwable)cause);
        }
        return job;
    }

    public CompletableFuture<Void> deleteJobWithTimeout(Job job) {
        return Delay.timeout((CompletableFuture)this.clientService.client().deleteJob(job), (long)30L, (TimeUnit)TimeUnit.SECONDS, () -> new TimeoutException("Timeout deleting job " + job.getJobId() + " " + job.getFromMediaType() + " -> " + job.getToMediaType()));
    }

    public String getSingleResultFileId(Job job) {
        List resultFileIds = job.getResultFileIds();
        if (resultFileIds == null || resultFileIds.isEmpty()) {
            throw new QetcherClientException("Expected 1 result file but have no result files");
        }
        if (resultFileIds.size() != 1) {
            LOG.warn("Expected 1 result file but is " + resultFileIds.size());
        }
        return (String)resultFileIds.get(0);
    }
}

