/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.liferay.client.impl.liferay71.scr;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class ServiceAvailableTracker<S>
implements AutoCloseable {
    private final ServiceTracker<S, S> tracker;

    public ServiceAvailableTracker(BundleContext bundleContext, Filter filter, final Consumer<ServiceReference<S>> onServiceAvailable, final Runnable onServiceUnavailable) {
        final HashSet knownReferences = new HashSet();
        this.tracker = new ServiceTracker<S, S>(bundleContext, filter, null){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public S addingService(ServiceReference<S> reference) {
                int countBefore;
                Set set = knownReferences;
                synchronized (set) {
                    countBefore = knownReferences.size();
                    knownReferences.add(reference);
                }
                if (countBefore == 0) {
                    onServiceAvailable.accept(reference);
                }
                return null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void removedService(ServiceReference<S> reference, S service) {
                int countAfter;
                Set set = knownReferences;
                synchronized (set) {
                    knownReferences.remove(reference);
                    countAfter = knownReferences.size();
                }
                if (countAfter == 0) {
                    onServiceUnavailable.run();
                }
            }
        };
    }

    public void open() {
        this.tracker.open();
    }

    public void open(boolean trackAllServices) {
        this.tracker.open(trackAllServices);
    }

    @Override
    public void close() {
        this.tracker.close();
    }
}

