/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.liferay.client.impl.liferay71.scr;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Supplier;

public class PropertiesFiles {
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private PropertiesFiles() {
    }

    public static HashMap<String, String> loadHashMap(Reader reader) throws IOException {
        return PropertiesFiles.loadMap(reader, HashMap::new);
    }

    public static HashMap<String, String> loadHashMap(InputStream in) throws IOException {
        return PropertiesFiles.loadMap(in, HashMap::new);
    }

    public static HashMap<String, String> loadHashMap(Path file) throws IOException {
        return PropertiesFiles.loadMap(file, HashMap::new);
    }

    public static <T extends Map<String, String>> T loadMap(Reader reader, Supplier<T> mapSupplier) throws IOException {
        Map map = (Map)mapSupplier.get();
        PropertiesFiles.load(reader, map::put);
        return (T)map;
    }

    public static <T extends Map<String, String>> T loadMap(InputStream in, Supplier<T> mapSupplier) throws IOException {
        Map map = (Map)mapSupplier.get();
        PropertiesFiles.load(in, map::put);
        return (T)map;
    }

    public static <T extends Map<String, String>> T loadMap(Path file, Supplier<T> mapSupplier) throws IOException {
        Map map = (Map)mapSupplier.get();
        try (InputStream in = Files.newInputStream(file, new OpenOption[0]);){
            PropertiesFiles.load(in, map::put);
        }
        return (T)map;
    }

    public static void store(Map<String, String> map, Writer writer) throws IOException {
        PropertiesFiles.store(map.entrySet(), writer, null);
    }

    public static void store(Map<String, String> map, Writer writer, String comments) throws IOException {
        PropertiesFiles.store(map.entrySet(), writer, comments);
    }

    public static void store(Map<String, String> map, OutputStream out) throws IOException {
        PropertiesFiles.store(map.entrySet(), out, null);
    }

    public static void store(Map<String, String> map, OutputStream out, String comments) throws IOException {
        PropertiesFiles.store(map.entrySet(), out, comments);
    }

    public static void store(Map<String, String> map, Path file) throws IOException {
        try (OutputStream out = Files.newOutputStream(file, new OpenOption[0]);){
            PropertiesFiles.store(map.entrySet(), out, null);
        }
    }

    public static void store(Map<String, String> map, Path file, String comments) throws IOException {
        try (OutputStream out = Files.newOutputStream(file, new OpenOption[0]);){
            PropertiesFiles.store(map.entrySet(), out, comments);
        }
    }

    public static void load(Reader reader, BiConsumer<String, String> consumer) throws IOException {
        Objects.requireNonNull(reader, "reader parameter is null");
        Objects.requireNonNull(consumer, "consumer parameter is null");
        PropertiesFiles.load0(new LineReader(reader), consumer);
    }

    public static void load(InputStream inStream, BiConsumer<String, String> consumer) throws IOException {
        Objects.requireNonNull(inStream, "inStream parameter is null");
        Objects.requireNonNull(consumer, "consumer parameter is null");
        PropertiesFiles.load0(new LineReader(inStream), consumer);
    }

    private static void load0(LineReader lr, BiConsumer<String, String> consumer) throws IOException {
        int limit;
        char[] convtBuf = new char[1024];
        while ((limit = lr.readLine()) >= 0) {
            int keyLen;
            char c = '\u0000';
            int valueStart = limit;
            boolean hasSep = false;
            boolean precedingBackslash = false;
            for (keyLen = 0; keyLen < limit; ++keyLen) {
                c = lr.lineBuf[keyLen];
                if (!(c != '=' && c != ':' || precedingBackslash)) {
                    valueStart = keyLen + 1;
                    hasSep = true;
                    break;
                }
                if (!(c != ' ' && c != '\t' && c != '\f' || precedingBackslash)) {
                    valueStart = keyLen + 1;
                    break;
                }
                precedingBackslash = c == '\\' ? !precedingBackslash : false;
            }
            while (valueStart < limit) {
                c = lr.lineBuf[valueStart];
                if (c != ' ' && c != '\t' && c != '\f') {
                    if (hasSep || c != '=' && c != ':') break;
                    hasSep = true;
                }
                ++valueStart;
            }
            String key = PropertiesFiles.loadConvert(lr.lineBuf, 0, keyLen, convtBuf);
            String value = PropertiesFiles.loadConvert(lr.lineBuf, valueStart, limit - valueStart, convtBuf);
            consumer.accept(key, value);
        }
    }

    private static String loadConvert(char[] in, int off, int len, char[] convtBuf) {
        if (convtBuf.length < len) {
            int newLen = len * 2;
            if (newLen < 0) {
                newLen = Integer.MAX_VALUE;
            }
            convtBuf = new char[newLen];
        }
        char[] out = convtBuf;
        int outLen = 0;
        int end = off + len;
        while (off < end) {
            int aChar;
            if ((aChar = in[off++]) == 92) {
                if ((aChar = in[off++]) == 117) {
                    int value = 0;
                    block6: for (int i = 0; i < 4; ++i) {
                        aChar = in[off++];
                        switch (aChar) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                value = (value << 4) + aChar - 48;
                                continue block6;
                            }
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: {
                                value = (value << 4) + 10 + aChar - 97;
                                continue block6;
                            }
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: {
                                value = (value << 4) + 10 + aChar - 65;
                                continue block6;
                            }
                            default: {
                                throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                            }
                        }
                    }
                    out[outLen++] = (char)value;
                    continue;
                }
                if (aChar == 116) {
                    aChar = 9;
                } else if (aChar == 114) {
                    aChar = 13;
                } else if (aChar == 110) {
                    aChar = 10;
                } else if (aChar == 102) {
                    aChar = 12;
                }
                out[outLen++] = aChar;
                continue;
            }
            out[outLen++] = aChar;
        }
        return new String(out, 0, outLen);
    }

    public static void store(Iterable<Map.Entry<String, String>> entrySet, Writer writer, String comments) throws IOException {
        Objects.requireNonNull(entrySet, "entrySetSupplier parameter is null");
        PropertiesFiles.store0(entrySet, writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer), comments, false);
    }

    public static void store(Iterable<Map.Entry<String, String>> entrySet, OutputStream out, String comments) throws IOException {
        Objects.requireNonNull(entrySet, "entrySet parameter is null");
        PropertiesFiles.store0(entrySet, new BufferedWriter(new OutputStreamWriter(out, "8859_1")), comments, true);
    }

    private static void store0(Iterable<Map.Entry<String, String>> entrySet, BufferedWriter bw, String comments, boolean escUnicode) throws IOException {
        if (comments != null) {
            PropertiesFiles.writeComments(bw, comments);
        }
        bw.write("#" + new Date().toString());
        bw.newLine();
        for (Map.Entry<String, String> e : entrySet) {
            String key = e.getKey();
            String val = e.getValue();
            key = PropertiesFiles.saveConvert(key, true, escUnicode);
            val = PropertiesFiles.saveConvert(val, false, escUnicode);
            bw.write(key + "=" + val);
            bw.newLine();
        }
        bw.flush();
    }

    private static void writeComments(BufferedWriter bw, String comments) throws IOException {
        int current;
        bw.write("#");
        int len = comments.length();
        int last = 0;
        char[] uu = new char[6];
        uu[0] = 92;
        uu[1] = 117;
        for (current = 0; current < len; ++current) {
            char c = comments.charAt(current);
            if (c <= '\u00ff' && c != '\n' && c != '\r') continue;
            if (last != current) {
                bw.write(comments.substring(last, current));
            }
            if (c > '\u00ff') {
                uu[2] = PropertiesFiles.toHex(c >> 12 & 0xF);
                uu[3] = PropertiesFiles.toHex(c >> 8 & 0xF);
                uu[4] = PropertiesFiles.toHex(c >> 4 & 0xF);
                uu[5] = PropertiesFiles.toHex(c & 0xF);
                bw.write(new String(uu));
            } else {
                bw.newLine();
                if (c == '\r' && current != len - 1 && comments.charAt(current + 1) == '\n') {
                    ++current;
                }
                if (current == len - 1 || comments.charAt(current + 1) != '#' && comments.charAt(current + 1) != '!') {
                    bw.write("#");
                }
            }
            last = current + 1;
        }
        if (last != current) {
            bw.write(comments.substring(last, current));
        }
        bw.newLine();
    }

    private static String saveConvert(String theString, boolean escapeSpace, boolean escapeUnicode) {
        int len = theString.length();
        int bufLen = len * 2;
        if (bufLen < 0) {
            bufLen = Integer.MAX_VALUE;
        }
        StringBuilder outBuffer = new StringBuilder(bufLen);
        block8: for (int x = 0; x < len; ++x) {
            char aChar = theString.charAt(x);
            if (aChar > '=' && aChar < '\u007f') {
                if (aChar == '\\') {
                    outBuffer.append('\\');
                    outBuffer.append('\\');
                    continue;
                }
                outBuffer.append(aChar);
                continue;
            }
            switch (aChar) {
                case ' ': {
                    if (x == 0 || escapeSpace) {
                        outBuffer.append('\\');
                    }
                    outBuffer.append(' ');
                    continue block8;
                }
                case '\t': {
                    outBuffer.append('\\');
                    outBuffer.append('t');
                    continue block8;
                }
                case '\n': {
                    outBuffer.append('\\');
                    outBuffer.append('n');
                    continue block8;
                }
                case '\r': {
                    outBuffer.append('\\');
                    outBuffer.append('r');
                    continue block8;
                }
                case '\f': {
                    outBuffer.append('\\');
                    outBuffer.append('f');
                    continue block8;
                }
                case '!': 
                case '#': 
                case ':': 
                case '=': {
                    outBuffer.append('\\');
                    outBuffer.append(aChar);
                    continue block8;
                }
                default: {
                    if ((aChar < ' ' || aChar > '~') & escapeUnicode) {
                        outBuffer.append('\\');
                        outBuffer.append('u');
                        outBuffer.append(PropertiesFiles.toHex(aChar >> 12 & 0xF));
                        outBuffer.append(PropertiesFiles.toHex(aChar >> 8 & 0xF));
                        outBuffer.append(PropertiesFiles.toHex(aChar >> 4 & 0xF));
                        outBuffer.append(PropertiesFiles.toHex(aChar & 0xF));
                        continue block8;
                    }
                    outBuffer.append(aChar);
                }
            }
        }
        return outBuffer.toString();
    }

    private static char toHex(int nibble) {
        return hexDigit[nibble & 0xF];
    }

    private static class LineReader {
        byte[] inByteBuf;
        char[] inCharBuf;
        char[] lineBuf = new char[1024];
        int inLimit = 0;
        int inOff = 0;
        InputStream inStream;
        Reader reader;

        public LineReader(InputStream inStream) {
            this.inStream = inStream;
            this.inByteBuf = new byte[8192];
        }

        public LineReader(Reader reader) {
            this.reader = reader;
            this.inCharBuf = new char[8192];
        }

        int readLine() throws IOException {
            int len = 0;
            char c = '\u0000';
            boolean skipWhiteSpace = true;
            boolean isCommentLine = false;
            boolean isNewLine = true;
            boolean appendedLineBegin = false;
            boolean precedingBackslash = false;
            boolean skipLF = false;
            while (true) {
                if (this.inOff >= this.inLimit) {
                    this.inLimit = this.inStream == null ? this.reader.read(this.inCharBuf) : this.inStream.read(this.inByteBuf);
                    this.inOff = 0;
                    if (this.inLimit <= 0) {
                        if (len == 0 || isCommentLine) {
                            return -1;
                        }
                        if (precedingBackslash) {
                            --len;
                        }
                        return len;
                    }
                }
                c = this.inStream != null ? (char)(this.inByteBuf[this.inOff++] & 0xFF) : this.inCharBuf[this.inOff++];
                if (skipLF) {
                    skipLF = false;
                    if (c == '\n') continue;
                }
                if (skipWhiteSpace) {
                    if (c == ' ' || c == '\t' || c == '\f' || !appendedLineBegin && (c == '\r' || c == '\n')) continue;
                    skipWhiteSpace = false;
                    appendedLineBegin = false;
                }
                if (isNewLine) {
                    isNewLine = false;
                    if (c == '#' || c == '!') {
                        if (this.inStream != null) {
                            while (this.inOff < this.inLimit) {
                                byte b;
                                if ((b = this.inByteBuf[this.inOff++]) != 10 && b != 13 && b != 92) continue;
                                c = (char)(b & 0xFF);
                                break;
                            }
                        } else {
                            while (this.inOff < this.inLimit && (c = this.inCharBuf[this.inOff++]) != '\n' && c != '\r' && c != '\\') {
                            }
                        }
                        isCommentLine = true;
                    }
                }
                if (c != '\n' && c != '\r') {
                    this.lineBuf[len++] = c;
                    if (len == this.lineBuf.length) {
                        int newLength = this.lineBuf.length * 2;
                        if (newLength < 0) {
                            newLength = Integer.MAX_VALUE;
                        }
                        char[] buf = new char[newLength];
                        System.arraycopy(this.lineBuf, 0, buf, 0, this.lineBuf.length);
                        this.lineBuf = buf;
                    }
                    if (c == '\\') {
                        precedingBackslash = !precedingBackslash;
                        continue;
                    }
                    precedingBackslash = false;
                    continue;
                }
                if (isCommentLine || len == 0) {
                    isCommentLine = false;
                    isNewLine = true;
                    skipWhiteSpace = true;
                    len = 0;
                    continue;
                }
                if (this.inOff >= this.inLimit) {
                    this.inLimit = this.inStream == null ? this.reader.read(this.inCharBuf) : this.inStream.read(this.inByteBuf);
                    this.inOff = 0;
                    if (this.inLimit <= 0) {
                        if (precedingBackslash) {
                            --len;
                        }
                        return len;
                    }
                }
                if (!precedingBackslash) break;
                --len;
                skipWhiteSpace = true;
                appendedLineBegin = true;
                precedingBackslash = false;
                if (c != '\r') continue;
                skipLF = true;
            }
            return len;
        }
    }
}

