/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.liferay.client.impl.liferay71;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.liferay.dynamic.data.mapping.kernel.DDMForm;
import com.liferay.dynamic.data.mapping.kernel.DDMFormField;
import com.liferay.dynamic.data.mapping.kernel.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.kernel.DDMFormValues;
import com.liferay.dynamic.data.mapping.kernel.UnlocalizedValue;
import com.liferay.dynamic.data.mapping.kernel.Value;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.metadata.RawMetadataProcessor;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.xml.Element;
import de.mklinger.micro.annotations.VisibleForTesting;
import de.mklinger.micro.maps.Maps;
import de.mklinger.qetcher.client.model.v1.MediaType;
import de.mklinger.qetcher.client.model.v1.MediaTypes;
import de.mklinger.qetcher.liferay.client.QetcherService;
import de.mklinger.qetcher.liferay.client.impl.liferay71.QetcherRawMetadataProcessorFields;
import de.mklinger.qetcher.liferay.client.impl.liferay71.scr.PropertiesFiles;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, property={"qetcher:Boolean=true", "service.ranking:Integer=1000"})
public class QetcherRawMetadataProcessorImpl
implements RawMetadataProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(QetcherRawMetadataProcessorImpl.class);
    private static final MediaType METADATA_FROM = MediaType.valueOf((String)"application/octet-stream");
    private static final MediaType METADATA_TO = MediaTypes.JSON.withParameter("extractMetadata", "true");
    private static final TypeReference<HashMap<String, Object>> JSON_MAP_TYPE = new TypeReference<HashMap<String, Object>>(){};
    private static final Map<String, Field[]> fields = new HashMap<String, Field[]>();
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final Map<String, String> metadataMapping = this.loadMetadataMapping();
    @Reference
    private QetcherService qetcherService;

    public Map<String, Field[]> getFields() {
        return fields;
    }

    public void exportGeneratedFiles(PortletDataContext portletDataContext, FileEntry fileEntry, Element fileEntryElement) {
    }

    public void importGeneratedFiles(PortletDataContext portletDataContext, FileEntry fileEntry, FileEntry importedFileEntry, Element fileEntryElement) throws Exception {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, DDMFormValues> getRawMetadataMap(String extension, String mimeType, File file) throws PortalException {
        try (FileInputStream in = new FileInputStream(file);){
            Map<String, DDMFormValues> map = this.getRawMetadataMap(extension, mimeType, in);
            return map;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public Map<String, DDMFormValues> getRawMetadataMap(String extension, String mimeType, InputStream inputStream) throws PortalException {
        Map<String, String> metadata = this.extractMetadata(inputStream, "metadata-" + extension);
        return this.createDDMFormValuesMap(metadata);
    }

    @VisibleForTesting
    protected Map<String, DDMFormValues> createDDMFormValuesMap(Map<String, String> metadata) {
        HashMap<String, DDMFormValues> ddmFormValuesMap = new HashMap<String, DDMFormValues>();
        if (metadata == null || metadata.isEmpty()) {
            return ddmFormValuesMap;
        }
        DDMFormValues ddmFormValues = this.createDDMFormValues(metadata);
        Map ddmFormFieldsValuesMap = ddmFormValues.getDDMFormFieldValuesMap();
        Set names = ddmFormFieldsValuesMap.keySet();
        if (names.isEmpty()) {
            return ddmFormValuesMap;
        }
        ddmFormValuesMap.put("TIKARAWMETADATA", ddmFormValues);
        return ddmFormValuesMap;
    }

    private DDMFormValues createDDMFormValues(Map<String, String> metadata) {
        Locale defaultLocale = LocaleUtil.getDefault();
        DDMForm ddmForm = this.createDDMForm(defaultLocale);
        DDMFormValues ddmFormValues = new DDMFormValues(ddmForm);
        ddmFormValues.addAvailableLocale(defaultLocale);
        ddmFormValues.setDefaultLocale(defaultLocale);
        for (String tikaName : this.getTikaPropertyNames()) {
            String value = metadata.get(tikaName);
            if (value == null || value.isEmpty()) continue;
            String liferayName = this.getLiferayDdmFieldName(tikaName);
            LOG.info("Metadata name '{}' with value '{}'", (Object)liferayName, (Object)value);
            DDMFormField ddmFormField = this.createTextDDMFormField(liferayName);
            ddmForm.addDDMFormField(ddmFormField);
            DDMFormFieldValue ddmFormFieldValue = new DDMFormFieldValue();
            ddmFormFieldValue.setName(liferayName);
            ddmFormFieldValue.setValue((Value)new UnlocalizedValue(value));
            ddmFormValues.addDDMFormFieldValue(ddmFormFieldValue);
        }
        return ddmFormValues;
    }

    private DDMForm createDDMForm(Locale defaultLocale) {
        DDMForm ddmForm = new DDMForm();
        ddmForm.addAvailableLocale(defaultLocale);
        ddmForm.setDefaultLocale(defaultLocale);
        return ddmForm;
    }

    private DDMFormField createTextDDMFormField(String name) {
        DDMFormField ddmFormField = new DDMFormField(name, "text");
        ddmFormField.setDataType("string");
        return ddmFormField;
    }

    private Collection<String> getTikaPropertyNames() {
        return this.metadataMapping.keySet();
    }

    private String getLiferayDdmFieldName(String tikaPropertyName) {
        return Objects.requireNonNull(this.metadataMapping.get(tikaPropertyName));
    }

    private static void _addFields(Class<?> clazz, List<Field> fields) {
        for (Field field : clazz.getFields()) {
            fields.add(field);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, String> loadMetadataMapping() {
        try (InputStream in = this.getClass().getResourceAsStream("metadata-mapping.properties");){
            LinkedHashMap linkedHashMap = PropertiesFiles.loadMap(in, LinkedHashMap::new);
            return linkedHashMap;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @VisibleForTesting
    protected Map<String, String> extractMetadata(InputStream inputStream, String referrer) throws PortalException, SystemException {
        Map<String, Object> rawMetadata;
        LOG.info("Getting metadata with referrer '{}'", (Object)referrer);
        try {
            rawMetadata = this.extractRawMetadata(inputStream, referrer);
        }
        catch (IOException e) {
            throw new SystemException((Throwable)e);
        }
        return this.toStringMap(rawMetadata);
    }

    @VisibleForTesting
    protected Map<String, String> toStringMap(Map<String, Object> rawMetadata) {
        HashMap metadata = Maps.newHashMap((int)rawMetadata.size());
        for (Map.Entry<String, Object> e : rawMetadata.entrySet()) {
            String name = e.getKey();
            Object value = e.getValue();
            if (!(value instanceof String) && !(value instanceof Number) && !(value instanceof Boolean)) continue;
            LOG.debug("Metadata: {} -> '{}'", (Object)name, value);
            metadata.put(name, String.valueOf(value));
        }
        return metadata;
    }

    @VisibleForTesting
    protected Map<String, Object> extractRawMetadata(InputStream inputStream, String referrer) throws IOException {
        byte[] json = this.qetcherService.convertToByteArray(inputStream, METADATA_FROM, METADATA_TO, referrer);
        return this.parseJson(json);
    }

    @VisibleForTesting
    protected Map<String, Object> parseJson(byte[] json) throws IOException {
        return (Map)this.objectMapper.readValue(json, JSON_MAP_TYPE);
    }

    static {
        ArrayList<Field> fields = new ArrayList<Field>();
        QetcherRawMetadataProcessorImpl._addFields(QetcherRawMetadataProcessorFields.ClimateForcast.class, fields);
        QetcherRawMetadataProcessorImpl._addFields(QetcherRawMetadataProcessorFields.CreativeCommons.class, fields);
        QetcherRawMetadataProcessorImpl._addFields(QetcherRawMetadataProcessorFields.DublinCore.class, fields);
        QetcherRawMetadataProcessorImpl._addFields(QetcherRawMetadataProcessorFields.Geographic.class, fields);
        QetcherRawMetadataProcessorImpl._addFields(QetcherRawMetadataProcessorFields.HttpHeaders.class, fields);
        QetcherRawMetadataProcessorImpl._addFields(QetcherRawMetadataProcessorFields.Message.class, fields);
        QetcherRawMetadataProcessorImpl._addFields(QetcherRawMetadataProcessorFields.Office.class, fields);
        QetcherRawMetadataProcessorImpl._addFields(QetcherRawMetadataProcessorFields.OfficeOpenXMLCore.class, fields);
        QetcherRawMetadataProcessorImpl._addFields(QetcherRawMetadataProcessorFields.TIFF.class, fields);
        QetcherRawMetadataProcessorImpl._addFields(QetcherRawMetadataProcessorFields.TikaMetadataKeys.class, fields);
        QetcherRawMetadataProcessorImpl._addFields(QetcherRawMetadataProcessorFields.TikaMimeKeys.class, fields);
        QetcherRawMetadataProcessorImpl._addFields(QetcherRawMetadataProcessorFields.XMPDM.class, fields);
        QetcherRawMetadataProcessorImpl.fields.put("TIKARAWMETADATA", fields.toArray(new Field[fields.size()]));
    }
}

