/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.liferay.client.impl.liferay71;

import com.liferay.portal.kernel.util.MimeTypes;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import de.mklinger.qetcher.liferay.client.impl.liferay71.scr.ScrServiceOverride;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class QetcherMimeTypesServiceOverride {
    private static final Logger LOG = LoggerFactory.getLogger(QetcherMimeTypesServiceOverride.class);
    private BundleContext bundleContext;
    private ScrServiceOverride<MimeTypes> serviceOverride;
    private MimeTypes originalService;
    private ServiceReference<MimeTypes> overridingServiceRef;

    @Activate
    public synchronized void activate(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.serviceOverride = new ScrServiceOverride<MimeTypes>(bundleContext, MimeTypes.class, "qetcher", "true", this::onOverridingServiceAvailable, this::onOverridingServiceUnavailable);
    }

    @Deactivate
    public synchronized void deactivate() {
        ScrServiceOverride<MimeTypes> override = this.serviceOverride;
        this.serviceOverride = null;
        override.close();
    }

    protected synchronized void onOverridingServiceAvailable(ServiceReference<MimeTypes> overridingServiceRef) {
        if (this.originalService != null) {
            throw new IllegalStateException();
        }
        if (this.overridingServiceRef != null) {
            throw new IllegalStateException();
        }
        this.overridingServiceRef = overridingServiceRef;
        MimeTypes overridingService = (MimeTypes)this.bundleContext.getService(overridingServiceRef);
        if (overridingService == null) {
            LOG.warn("Service unavailable");
        } else {
            LOG.info("Using service for {}: {}", (Object)MimeTypesUtil.class.getSimpleName(), (Object)overridingService);
            this.originalService = MimeTypesUtil.getMimeTypes();
            new MimeTypesUtil().setMimeTypes(overridingService);
        }
    }

    protected synchronized void onOverridingServiceUnavailable() {
        if (this.originalService == null) {
            LOG.warn("Unable to restore original service for {}", (Object)MimeTypesUtil.class.getSimpleName());
        } else {
            LOG.info("Restoring original service for {}: {}", (Object)MimeTypesUtil.class.getSimpleName(), (Object)this.originalService);
            new MimeTypesUtil().setMimeTypes(this.originalService);
            this.originalService = null;
        }
        this.bundleContext.ungetService(this.overridingServiceRef);
    }
}

