package de.mklinger.qetcher.liferay.client.impl.liferay71;

import java.util.concurrent.TimeUnit;

import org.osgi.service.component.annotations.Component;

@Component(service = QetcherTimeoutConfig.class)
public class QetcherTimeoutConfig {
	private final TimeValue shortTimeout = TimeValue.seconds(30);
	private final TimeValue uploadTimeout = TimeValue.hours(1);
	private final TimeValue downloadTimeout = TimeValue.hours(1);

	public TimeValue getShortTimeout() {
		return shortTimeout;
	}

	public TimeValue getUploadTimeout() {
		return uploadTimeout;
	}

	public TimeValue getDownloadTimeout() {
		return downloadTimeout;
	}

	public static class TimeValue {
		private final long time;
		private final TimeUnit timeUnit;

		public TimeValue(long time, TimeUnit timeUnit) {
			this.time = time;
			this.timeUnit = timeUnit;
		}

		public static TimeValue seconds(long seconds) {
			return new TimeValue(seconds, TimeUnit.SECONDS);
		}

		public static TimeValue hours(long hours) {
			return new TimeValue(hours, TimeUnit.HOURS);
		}

		public long time() {
			return time;
		}

		public TimeUnit unit() {
			return timeUnit;
		}
	}
}
