package de.mklinger.qetcher.liferay.client.impl.liferay71;

import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.liferay.portal.kernel.metadata.RawMetadataProcessor;
import com.liferay.portal.kernel.metadata.RawMetadataProcessorUtil;

import de.mklinger.qetcher.liferay.client.impl.liferay71.scr.ScrServiceOverride;

@Component(immediate = true)
public class QetcherRawMetadataProcessorServiceOverride {
	private static final Logger LOG = LoggerFactory.getLogger(QetcherRawMetadataProcessorServiceOverride.class);

	private BundleContext bundleContext;
	private ScrServiceOverride<RawMetadataProcessor> serviceOverride;

	private RawMetadataProcessor originalService;
	private ServiceReference<RawMetadataProcessor> overridingServiceRef;

	@Activate
	public synchronized void activate(BundleContext bundleContext) {
		this.bundleContext = bundleContext;
		this.serviceOverride = new ScrServiceOverride<>(bundleContext,
				RawMetadataProcessor.class,
				"qetcher", "true",
				this::onOverridingServiceAvailable,
				this::onOverridingServiceUnavailable);
	}

	@Deactivate
	public synchronized void deactivate() {
		final ScrServiceOverride<RawMetadataProcessor> override = this.serviceOverride;
		this.serviceOverride = null;
		override.close();
	}

	protected synchronized void onOverridingServiceAvailable(ServiceReference<RawMetadataProcessor> overridingServiceRef) {
		if (this.originalService != null) {
			throw new IllegalStateException();
		}
		if (this.overridingServiceRef != null) {
			throw new IllegalStateException();
		}

		this.overridingServiceRef = overridingServiceRef;

		final RawMetadataProcessor overridingService = bundleContext.getService(overridingServiceRef);
		if (overridingService == null) {
			LOG.warn("Service unavailable");
		} else {
			LOG.info("Using service for {}: {}", RawMetadataProcessorUtil.class.getSimpleName(), overridingService);
			originalService = RawMetadataProcessorUtil.getRawMetadataProcessor();
			new RawMetadataProcessorUtil().setRawMetadataProcessor(overridingService);
		}
	}

	protected synchronized void onOverridingServiceUnavailable() {
		if (originalService == null) {
			LOG.warn("Unable to restore original service for {}", RawMetadataProcessorUtil.class.getSimpleName());
		} else {
			LOG.info("Restoring original service for {}: {}", RawMetadataProcessorUtil.class.getSimpleName(), originalService);
			new RawMetadataProcessorUtil().setRawMetadataProcessor(originalService);
			originalService = null;
		}

		bundleContext.ungetService(overridingServiceRef);
	}
}
