package de.mklinger.qetcher.liferay.client.impl.liferay71;

import java.io.InputStream;
import java.util.List;
import java.util.Set;
import java.util.Vector;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.liferay.document.library.kernel.document.conversion.DocumentConversionUtil;
import com.liferay.document.library.kernel.model.DLProcessorConstants;
import com.liferay.document.library.kernel.store.DLStoreUtil;
import com.liferay.document.library.kernel.util.DLPreviewableProcessor;
import com.liferay.document.library.kernel.util.PDFProcessor;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.messaging.DestinationNames;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.util.ContentTypes;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.PropsKeys;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Element;

public abstract class QetcherPDFProcessorImplBoilerplate  extends DLPreviewableProcessor implements PDFProcessor {
	private static final Logger LOG = LoggerFactory.getLogger(QetcherPDFProcessorImplBoilerplate.class);

	private final boolean fileEntryPreviewEnabled;
	private final boolean fileEntryThumbnailEnabled;
	private final int previewDocumentDocumentDpi;

	protected final List<Long> fileVersionIds = new Vector<>();

	public QetcherPDFProcessorImplBoilerplate() {
		this.fileEntryPreviewEnabled = GetterUtil.getBoolean(PropsUtil.get(PropsKeys.DL_FILE_ENTRY_PREVIEW_ENABLED));
		this.fileEntryThumbnailEnabled = GetterUtil.getBoolean(PropsUtil.get(PropsKeys.DL_FILE_ENTRY_THUMBNAIL_ENABLED));
		this.previewDocumentDocumentDpi = GetterUtil.getInteger(PropsUtil.get(PropsKeys.DL_FILE_ENTRY_PREVIEW_DOCUMENT_DPI));
	}

	@Override
	public void afterPropertiesSet() throws Exception {
		FileUtil.mkdirs(DECRYPT_TMP_PATH);
		FileUtil.mkdirs(PREVIEW_TMP_PATH);
		FileUtil.mkdirs(THUMBNAIL_TMP_PATH);
	}

	@Override
	public void destroy() {
		FileUtil.deltree(TMP_PATH);
	}

	@Override
	public String getType() {
		return DLProcessorConstants.PDF_PROCESSOR;
	}

	@Override
	public InputStream getPreviewAsStream(FileVersion fileVersion, int index) throws Exception {
		return doGetPreviewAsStream(fileVersion, index, PREVIEW_TYPE);
	}

	@Override
	public int getPreviewFileCount(FileVersion fileVersion) {
		try {
			return doGetPreviewFileCount(fileVersion);
		} catch (final Exception e) {
			LOG.error("Error in super.doGetPreviewFileCount()", e);
			return 0;
		}
	}

	@Override
	public long getPreviewFileSize(FileVersion fileVersion, int index) throws Exception {
		return doGetPreviewFileSize(fileVersion, index);
	}

	@Override
	public InputStream getThumbnailAsStream(FileVersion fileVersion, int index) throws Exception {
		return doGetThumbnailAsStream(fileVersion, index);
	}

	@Override
	public long getThumbnailFileSize(FileVersion fileVersion, int index) throws Exception {
		return doGetThumbnailFileSize(fileVersion, index);
	}

	@Override
	public boolean hasImages(FileVersion fileVersion) {
		boolean hasImages = false;

		try {
			hasImages = _hasImages(fileVersion);

			if (!hasImages && isSupported(fileVersion)) {
				queueGeneration(null, fileVersion);
			}
		}
		catch (final Exception e) {
			LOG.error("Error in hasImages()", e);
		}

		return hasImages;
	}

	@Override
	public boolean isDocumentSupported(FileVersion fileVersion) {
		return isSupported(fileVersion);
	}

	@Override
	public boolean isDocumentSupported(String mimeType) {
		return isSupported(mimeType);
	}

	@Override
	public boolean isSupported(String mimeType) {
		if (Validator.isNull(mimeType)) {
			return false;
		}

		if (mimeType.equals(ContentTypes.APPLICATION_PDF) ||
				mimeType.equals(ContentTypes.APPLICATION_X_PDF)) {

			return true;
		}

		if (DocumentConversionUtil.isEnabled()) {
			final Set<String> extensions = MimeTypesUtil.getExtensions(mimeType);

			for (String extension : extensions) {
				extension = withoutLeadingDot(extension);

				final String[] targetExtensions =
						DocumentConversionUtil.getConversions(extension);

				for (final String targetExtension : targetExtensions) {
					if ("pdf".equals(withoutLeadingDot(targetExtension))) {
						return true;
					}
				}
			}
		}

		return false;
	}

	private String withoutLeadingDot(String s) {
		if (s == null || s.length() < 2) {
			return s;
		}

		if (s.startsWith(".")) {
			return s.substring(1);
		} else {
			return s;
		}
	}

	@Override
	protected void doExportGeneratedFiles(
			PortletDataContext portletDataContext, FileEntry fileEntry,
			Element fileEntryElement)
					throws Exception {

		exportThumbnails(
				portletDataContext, fileEntry, fileEntryElement, "pdf");

		exportPreviews(portletDataContext, fileEntry, fileEntryElement);
	}

	protected void exportPreviews(
			PortletDataContext portletDataContext, FileEntry fileEntry,
			Element fileEntryElement)
					throws Exception {

		final FileVersion fileVersion = fileEntry.getFileVersion();

		if (!isSupported(fileVersion) || !_hasImages(fileVersion)) {
			return;
		}

		if (!portletDataContext.isPerformDirectBinaryImport()) {
			final int previewFileCount = getPreviewFileCount(fileVersion);

			fileEntryElement.addAttribute(
					"bin-path-pdf-preview-count", String.valueOf(previewFileCount));

			for (int i = 0; i < previewFileCount; i++) {
				exportPreview(
						portletDataContext, fileEntry, fileEntryElement, "pdf",
						PREVIEW_TYPE, i);
			}
		}
	}

	protected boolean _hasImages(FileVersion fileVersion) throws Exception {
		if (fileEntryPreviewEnabled) {
			if (!hasPreview(fileVersion)) {
				return false;
			}
		}

		return hasThumbnails(fileVersion);
	}

	protected boolean hasPreview(FileVersion fileVersion) throws Exception {
		return hasPreview(fileVersion, null);
	}

	@Override
	protected boolean hasPreview(FileVersion fileVersion, String type) throws Exception {
		final String previewFilePath = getPreviewFilePath(fileVersion, 1);

		return DLStoreUtil.hasFile(
				fileVersion.getCompanyId(), REPOSITORY_ID, previewFilePath);
	}

	@Override
	protected void doImportGeneratedFiles(
			PortletDataContext portletDataContext, FileEntry fileEntry,
			FileEntry importedFileEntry, Element fileEntryElement)
					throws Exception {

		importThumbnails(
				portletDataContext, fileEntry, importedFileEntry, fileEntryElement,
				"pdf");

		importPreviews(
				portletDataContext, fileEntry, importedFileEntry, fileEntryElement);
	}

	protected void importPreviews(
			PortletDataContext portletDataContext, FileEntry fileEntry,
			FileEntry importedFileEntry, Element fileEntryElement)
					throws Exception {

		final int previewFileCount = GetterUtil.getInteger(
				fileEntryElement.attributeValue("bin-path-pdf-preview-count"));

		for (int i = 0; i < previewFileCount; i++) {
			importPreview(
					portletDataContext, fileEntry, importedFileEntry,
					fileEntryElement, "pdf", PREVIEW_TYPE, i);
		}
	}

	@Override
	protected List<Long> getFileVersionIds() {
		return fileVersionIds;
	}

	@Override
	protected String getPreviewType(FileVersion fileVersion) {
		return PREVIEW_TYPE;
	}

	@Override
	protected String getThumbnailType(FileVersion fileVersion) {
		return THUMBNAIL_TYPE;
	}

	private void queueGeneration(FileVersion sourceFileVersion, FileVersion destinationFileVersion) {
		if (fileVersionIds.contains(destinationFileVersion.getFileVersionId())) {
			return;
		}

		boolean generateImages = false;

		final String extension = destinationFileVersion.getExtension();

		if (extension.equals("pdf")) {
			generateImages = true;
		}
		else if (DocumentConversionUtil.isEnabled()) {
			final String[] conversions = DocumentConversionUtil.getConversions(
					extension);

			for (final String conversion : conversions) {
				if (conversion.equals("pdf")) {
					generateImages = true;

					break;
				}
			}
		}

		if (generateImages) {
			fileVersionIds.add(destinationFileVersion.getFileVersionId());

			sendGenerationMessage(
					DestinationNames.DOCUMENT_LIBRARY_PDF_PROCESSOR,
					sourceFileVersion, destinationFileVersion);
		}
	}

	protected boolean _isGeneratePreview(FileVersion fileVersion) throws Exception {
		return fileEntryPreviewEnabled && !hasPreview(fileVersion);
	}

	protected boolean _isGenerateThumbnail(FileVersion fileVersion) throws Exception {
		return fileEntryThumbnailEnabled && !hasThumbnail(fileVersion, THUMBNAIL_INDEX_DEFAULT);
	}

	protected int getPreviewDocumentDocumentDpi() {
		return previewDocumentDocumentDpi;
	}
}
