package de.mklinger.qetcher.liferay.client.impl.abstraction.liferay71;

import java.io.Serializable;

import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

import com.liferay.portal.kernel.cache.MultiVMPool;
import com.liferay.portal.kernel.cache.PortalCache;

import de.mklinger.qetcher.liferay.abstraction.CacheTool;

@Component
public class CacheToolImpl implements CacheTool {
	@Reference
	private MultiVMPool multiVmPool;

	@SuppressWarnings("unchecked")
	private <K extends Serializable, V> PortalCache<K, V> getPortalCache(final String name) {
		return (PortalCache<K, V>) multiVmPool.getPortalCache(name);
	}

	@Override
	public Object get(String cacheName, String key) {
		return getPortalCache(cacheName).get(key);
	}

	@Override
	public void put(String cacheName, String key, Serializable value) {
		getPortalCache(cacheName).put(key, value);
	}
}
