package de.mklinger.qetcher.liferay.client.impl;

import java.util.Set;

import com.liferay.portal.configuration.metatype.annotations.ExtendedObjectClassDefinition;

import aQute.bnd.annotation.metatype.Meta;

/**
 * @author Marc Klinger - mklinger[at]mklinger[dot]de
 */

/**
 * Qetcher configuration.
 *
 * To override the defaults, create the file
 *
 * liferay/osgi/configs/de.mklinger.qetcher.liferay.client.impl.QetcherConfiguration.cfg
 *
 * and set properties named like the methods in this interface.
 *
 * @author Marc Klinger - mklinger[at]mklinger[dot]de
 */
@ExtendedObjectClassDefinition(category = "connectors")
@Meta.OCD(
		id = QetcherConfiguration.ID,
		localization = "content/Language",
		name = "qetcher-configuration-name")
public interface QetcherConfiguration {
	// Note: For Liferay UI integration to work, the id must match the full qualified class name of this interface.
	String ID = "de.mklinger.qetcher.liferay.client.impl.QetcherConfiguration";

	@Meta.AD(deflt = "",
			description = "service-addresses-description",
			name = "service-addresses-name",
			required = true)
	String[] serviceAddresses();

	@Meta.AD(deflt = "",
			description = "key-store-location-description",
			name = "key-store-location-name",
			required = false)
	String keyStoreLocation();

	@Meta.AD(deflt = "PKCS12",
			description = "key-store-type-description",
			name = "key-store-type-name",
			required = false)
	String keyStoreType();

	@Meta.AD(deflt = "",
			description = "key-store-password-description",
			name = "key-store-password-name",
			required = false)
	String keyStorePassword();

	@Meta.AD(deflt = "",
			description = "key-password-description",
			name = "key-password-name",
			required = false)
	String keyPassword();

	@Meta.AD(deflt = "bmp|wbmp|png|x-png|gif|tif|tiff|jpeg|jpg|jfif|jfif-tbnl|jpe|xcf|psd|psp|ico|fits|fit|pnm|pat|cel|sgi|icon|bw|rgb",
			cardinality = Integer.MAX_VALUE,
			description = "conversion-extensions-singlepage-description",
			name = "conversion-extensions-singlepage-name",
			required = false)
	Set<String> conversionExtensionsSinglepage();

	@Meta.AD(deflt = "jpg|bmp|png|gif",
			cardinality = Integer.MAX_VALUE,
			description = "conversion-extensions-whitelist-singlepage-description",
			name = "conversion-extensions-whitelist-singlepage-name",
			required = false)
	Set<String> conversionExtensionsWhitelistSinglepage();

	@Meta.AD(deflt = "pdf|svg|swf|odp|ppt|pptx|sxi|csv|ods|sxc|tsv|xls|xlsx|doc|docx|odt|rtf|sxw|txt",
			cardinality = Integer.MAX_VALUE,
			description = "conversion-extensions-whitelist-multipage-description",
			name = "conversion-extensions-whitelist-multipage-name",
			required = false)
	Set<String> conversionExtensionsWhitelistMultipage();

	@Meta.AD(deflt = "true",
			description = "document-conversion-cache-enabled-description",
			name = "document-conversion-cache-enabled-name",
			required = false)
	boolean documentConversionCacheEnabled();
}
