/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.liferay.client.impl;

import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import de.mklinger.micro.annotations.VisibleForTesting;
import de.mklinger.micro.keystores.KeyStores;
import de.mklinger.qetcher.client.InputConversionFile;
import de.mklinger.qetcher.client.InputJob;
import de.mklinger.qetcher.client.QetcherClient;
import de.mklinger.qetcher.client.QetcherClientBuilders;
import de.mklinger.qetcher.client.QetcherClientException;
import de.mklinger.qetcher.client.QetcherClientVersion;
import de.mklinger.qetcher.client.httpclient.BodyProviders;
import de.mklinger.qetcher.liferay.client.QetcherClientService;
import de.mklinger.qetcher.liferay.client.impl.DefunctQetcherClient;
import de.mklinger.qetcher.liferay.client.impl.NonClosingQetcherClient;
import de.mklinger.qetcher.liferay.client.impl.QetcherClientCertificateInfo;
import de.mklinger.qetcher.liferay.client.impl.QetcherConfiguration;
import de.mklinger.qetcher.liferay.client.impl.QetcherTrustStoreSupplier;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Path;
import java.security.KeyStore;
import java.util.Map;
import java.util.function.Supplier;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(configurationPid={"de.mklinger.qetcher.liferay.client.impl.QetcherConfiguration"}, configurationPolicy=ConfigurationPolicy.REQUIRE)
public class QetcherClientServiceImpl
implements QetcherClientService {
    private static final Logger LOG = LoggerFactory.getLogger(QetcherClientServiceImpl.class);
    private QetcherTrustStoreSupplier trustStoreSupplier;
    private Map<String, Object> configurationProperties;
    private QetcherClient client;

    @Reference(policy=ReferencePolicy.DYNAMIC)
    public synchronized void setTrustStoreSupplier(QetcherTrustStoreSupplier trustStoreSupplier) {
        LOG.info("Trust store supplier was set");
        this.trustStoreSupplier = trustStoreSupplier;
        this.resetClient();
    }

    public synchronized void unsetTrustStoreSupplier(QetcherTrustStoreSupplier trustStoreSupplier) {
        LOG.info("Trust store supplier was unset");
        this.trustStoreSupplier = null;
        this.resetClient();
    }

    public synchronized void updatedTrustStoreSupplier(QetcherTrustStoreSupplier trustStoreSupplier) {
        LOG.info("Trust store supplier was updated");
        this.trustStoreSupplier = trustStoreSupplier;
        this.resetClient();
    }

    @Activate
    @Modified
    public synchronized void activate(Map<String, Object> properties) {
        LOG.info("Configuration was set");
        this.configurationProperties = properties;
        this.resetClient();
    }

    private synchronized void resetClient() {
        QetcherConfiguration configuration;
        this.closeClient();
        if (this.configurationProperties == null) {
            LOG.error("Could not create Qetcher client as no configuration is available");
            this.client = new DefunctQetcherClient("Qetcher client is not functional. No configuration available");
            return;
        }
        if (this.trustStoreSupplier == null) {
            LOG.error("Could not create Qetcher client as no trust store supplier is available");
            this.client = new DefunctQetcherClient("Qetcher client is not functional. No trust store supplier available");
            return;
        }
        try {
            configuration = (QetcherConfiguration)ConfigurableUtil.createConfigurable(QetcherConfiguration.class, this.configurationProperties);
        }
        catch (Exception e) {
            String causeMessages = QetcherClientServiceImpl.getCauseMessages(e);
            LOG.error("Error creating Qetcher configuration: {}", (Object)causeMessages);
            this.client = new DefunctQetcherClient("Qetcher client is not functional. There was an error creating Qetcher configuration: " + causeMessages);
            return;
        }
        try {
            this.client = this.newClient(configuration);
            LOG.info("Successfully created new Qetcher client");
        }
        catch (Exception e) {
            String causeMessages = QetcherClientServiceImpl.getCauseMessages(e);
            LOG.error("Error creating Qetcher client: {}", (Object)causeMessages, (Object)e);
            this.client = new DefunctQetcherClient("Qetcher client is not functional. There was an error creating Qetcher client instance: " + causeMessages);
            return;
        }
    }

    private static String getCauseMessages(Throwable e) {
        return QetcherClientServiceImpl.getCauseMessages(e, ": ");
    }

    private static String getCauseMessages(Throwable e, String separator) {
        StringBuilder sb = new StringBuilder();
        for (Throwable cause = e; cause != null; cause = cause.getCause()) {
            String message = cause.getMessage();
            if (message == null) continue;
            if (sb.length() > 0) {
                sb.append(separator);
            }
            sb.append(message);
        }
        return sb.toString();
    }

    @Deactivate
    public synchronized void closeClient() {
        try {
            if (this.client != null) {
                LOG.info("Closing Qetcher client");
                QetcherClient oldClient = this.client;
                this.client = null;
                if (oldClient instanceof NonClosingQetcherClient) {
                    ((NonClosingQetcherClient)oldClient).reallyClose();
                } else {
                    oldClient.close();
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Error closing Qetcher client", (Throwable)e);
        }
    }

    private NonClosingQetcherClient newClient(QetcherConfiguration configuration) {
        String[] serviceAddresses = configuration.serviceAddresses();
        if (serviceAddresses == null || serviceAddresses.length == 0) {
            throw new QetcherClientException("No Qetcher service addresses configured");
        }
        KeyStore keyStore = this.loadKeyStore(configuration);
        String keyPassword = this.emptyToNull(configuration.keyPassword());
        KeyStore trustStore = this.trustStoreSupplier.get();
        QetcherClient qetcherClient = this.newClientBuilder().serviceAddresses(serviceAddresses).keyStore(keyStore, keyPassword).trustStore(trustStore).build();
        LOG.info("Initialized new Qetcher client, version {}", (Object)QetcherClientVersion.getVersion());
        LOG.info("Using Qetcher service addresses: {}", (Object)configuration.serviceAddresses());
        new QetcherClientCertificateInfo(keyStore).log();
        return new NonClosingQetcherClient(qetcherClient);
    }

    @VisibleForTesting
    protected QetcherClient.Builder newClientBuilder() {
        return QetcherClientBuilders.client();
    }

    private KeyStore loadKeyStore(QetcherConfiguration configuration) {
        String keyStoreLocation = this.getKeyStoreLocation(configuration);
        String keyStorePassword = this.emptyToNull(configuration.keyStorePassword());
        String keyStoreType = this.emptyToNull(configuration.keyStoreType());
        return KeyStores.load((String)keyStoreLocation, (String)keyStorePassword, (String)keyStoreType);
    }

    private String getKeyStoreLocation(QetcherConfiguration configuration) {
        String keyStoreLocation = configuration.keyStoreLocation();
        if (keyStoreLocation == null || keyStoreLocation.isEmpty()) {
            keyStoreLocation = PropsUtil.get((String)"liferay.home") + "/data/qetcher/qetcher-key.p12";
            LOG.info("No Qetcher key store location configured. Using default location: {}", (Object)keyStoreLocation);
        }
        return keyStoreLocation;
    }

    private String emptyToNull(String s) {
        if (s != null && s.trim().isEmpty()) {
            return null;
        }
        return s;
    }

    @Override
    public synchronized QetcherClient client() {
        if (this.client == null) {
            throw new QetcherClientException("Qetcher client is not initialized. Check configuration and previous log.");
        }
        return this.client;
    }

    @Override
    public InputConversionFile.Builder inputFile() {
        return QetcherClientBuilders.inputFile();
    }

    @Override
    public InputConversionFile.Builder inputFileFor(File inputFile) {
        return QetcherClientBuilders.inputFileFor((File)inputFile);
    }

    @Override
    public InputConversionFile.Builder inputFileFor(Path inputFile) {
        return QetcherClientBuilders.inputFileFor((Path)inputFile);
    }

    @Override
    public InputConversionFile.Builder inputFileFor(Supplier<InputStream> inputStreamSupplier) {
        return QetcherClientBuilders.inputFile().bodyProvider(BodyProviders.fromInputStream(inputStreamSupplier));
    }

    @Override
    public InputJob.Builder job() {
        return QetcherClientBuilders.job();
    }
}

