package de.mklinger.qetcher.liferay.client.impl.abstraction.liferay71;

import java.io.IOException;
import java.io.InputStream;

import com.liferay.portal.kernel.exception.ImageResolutionException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.image.ImageToolUtil;
import com.liferay.portal.kernel.service.ImageServiceUtil;

import de.mklinger.qetcher.liferay.abstraction.Image;
import de.mklinger.qetcher.liferay.abstraction.ImageTool;
import de.mklinger.qetcher.liferay.abstraction.LiferayException;

/**
 * @author Marc Klinger - mklinger[at]mklinger[dot]de
 */
public class ImageToolImpl implements ImageTool {
	@Override
	public Image newImage() {
		return new ImageImpl();
	}

	@Override
	public Image getImage(final InputStream in) throws LiferayException, IOException {
		try {
			return fromLiferayImage(ImageToolUtil.getImage(in));
		} catch (final ImageResolutionException e) {
			throw new LiferayException(e);
		}
	}

	@Override
	public Image getImage(final long imageId) throws LiferayException {
		try {
			return fromLiferayImage(ImageServiceUtil.getImage(imageId));
		} catch (PortalException | SystemException e) {
			throw new LiferayException(e);
		}
	}

	@Override
	public Image getDefaultCompanyLogo() {
		return fromLiferayImage(ImageToolUtil.getDefaultCompanyLogo());
	}

	@Override
	public Image getDefaultOrganizationLogo() {
		return fromLiferayImage(ImageToolUtil.getDefaultOrganizationLogo());
	}

	@Override
	public Image getDefaultUserFemalePortrait() {
		return fromLiferayImage(ImageToolUtil.getDefaultUserFemalePortrait());
	}

	@Override
	public Image getDefaultUserMalePortrait() {
		return fromLiferayImage(ImageToolUtil.getDefaultUserMalePortrait());
	}

	@Override
	public Image updateUserPortrait(final Image image, final long imageId) throws LiferayException {
		throw new UnsupportedOperationException();
	}

	private Image fromLiferayImage(final com.liferay.portal.kernel.model.Image liferayImage) {
		if (liferayImage == null) {
			return null;
		}
		return new LiferayImageWrapper(liferayImage);
	}
}
